"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySeverity = AnomalySeverity;
exports.SelectAnomalySeverity = SelectAnomalySeverity;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _anomaly_detection = require("../../../../../common/anomaly_detection");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AnomalySeverity({
  type
}) {
  const selectedOption = _apm_rule_types.ANOMALY_ALERT_SEVERITY_TYPES.find(option => option.type === type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: (0, _anomaly_detection.getSeverityColor)(selectedOption.threshold),
    style: {
      lineHeight: 'inherit'
    }
  }, selectedOption.label);
}
function SelectAnomalySeverity({
  onChange,
  value
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    hasDividers: true,
    style: {
      width: 200
    },
    options: _apm_rule_types.ANOMALY_ALERT_SEVERITY_TYPES.map(option => ({
      value: option.type,
      inputDisplay: /*#__PURE__*/_react.default.createElement(AnomalySeverity, {
        type: option.type
      }),
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AnomalySeverity, {
        type: option.type
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": "SelectAnomalySeverity option text"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.alerts.anomalySeverity.scoreDetailsDescription",
        defaultMessage: "score {value} {value, select, critical {} other {and above}}",
        values: {
          value: option.type
        }
      }))))
    })),
    valueOfSelected: value,
    onChange: selectedValue => {
      onChange(selectedValue);
    }
  });
}