"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmFeatureFlagName = void 0;
exports.getApmFeatureFlags = getApmFeatureFlags;
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ApmFeatureFlagName = exports.ApmFeatureFlagName = /*#__PURE__*/function (ApmFeatureFlagName) {
  ApmFeatureFlagName["AgentConfigurationAvailable"] = "agentConfigurationAvailable";
  ApmFeatureFlagName["ConfigurableIndicesAvailable"] = "configurableIndicesAvailable";
  ApmFeatureFlagName["InfrastructureTabAvailable"] = "infrastructureTabAvailable";
  ApmFeatureFlagName["InfraUiAvailable"] = "infraUiAvailable";
  ApmFeatureFlagName["MigrationToFleetAvailable"] = "migrationToFleetAvailable";
  ApmFeatureFlagName["SourcemapApiAvailable"] = "sourcemapApiAvailable";
  ApmFeatureFlagName["StorageExplorerAvailable"] = "storageExplorerAvailable";
  ApmFeatureFlagName["RuleFormV2Enabled"] = "ruleFormV2Enabled";
  return ApmFeatureFlagName;
}({});
const apmFeatureFlagMap = {
  [ApmFeatureFlagName.AgentConfigurationAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.ConfigurableIndicesAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.InfrastructureTabAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.InfraUiAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.MigrationToFleetAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.SourcemapApiAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.StorageExplorerAvailable]: {
    default: true,
    type: t.boolean
  },
  [ApmFeatureFlagName.RuleFormV2Enabled]: {
    default: false,
    type: t.boolean
  }
};
function getApmFeatureFlags() {
  return (0, _lodash.mapValues)(apmFeatureFlagMap, (value, key) => value.default);
}