"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaUnknownArray = exports.schemaUnknown = exports.schemaStringOrNumberArray = exports.schemaStringOrNumber = exports.schemaStringArray = exports.schemaString = exports.schemaNumberArray = exports.schemaNumber = exports.schemaGeoPointArray = exports.schemaGeoPoint = exports.schemaDateRangeArray = exports.schemaDateRange = exports.schemaDateArray = exports.schemaDate = exports.schemaBooleanArray = exports.schemaBoolean = exports.IsoDateString = exports.AlertSchema = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// ---------------------------------- WARNING ----------------------------------
// this file was generated, and should not be edited by hand
// ---------------------------------- WARNING ----------------------------------

const ISO_DATE_PATTERN = /^d{4}-d{2}-d{2}Td{2}:d{2}:d{2}.d{3}Z$/;
const IsoDateString = exports.IsoDateString = new rt.Type('IsoDateString', rt.string.is, (input, context) => {
  if (typeof input === 'string' && ISO_DATE_PATTERN.test(input)) {
    return rt.success(input);
  } else {
    return rt.failure(input, context);
  }
}, rt.identity);
const schemaUnknown = exports.schemaUnknown = rt.unknown;
const schemaUnknownArray = exports.schemaUnknownArray = rt.array(rt.unknown);
const schemaString = exports.schemaString = rt.string;
const schemaStringArray = exports.schemaStringArray = rt.array(schemaString);
const schemaNumber = exports.schemaNumber = rt.number;
const schemaNumberArray = exports.schemaNumberArray = rt.array(schemaNumber);
const schemaDate = exports.schemaDate = rt.union([IsoDateString, schemaNumber]);
const schemaDateArray = exports.schemaDateArray = rt.array(schemaDate);
const schemaDateRange = exports.schemaDateRange = rt.partial({
  gte: schemaDate,
  lte: schemaDate
});
const schemaDateRangeArray = exports.schemaDateRangeArray = rt.array(schemaDateRange);
const schemaStringOrNumber = exports.schemaStringOrNumber = rt.union([schemaString, schemaNumber]);
const schemaStringOrNumberArray = exports.schemaStringOrNumberArray = rt.array(schemaStringOrNumber);
const schemaBoolean = exports.schemaBoolean = rt.boolean;
const schemaBooleanArray = exports.schemaBooleanArray = rt.array(schemaBoolean);
const schemaGeoPointCoords = rt.type({
  type: schemaString,
  coordinates: schemaNumberArray
});
const schemaGeoPointString = schemaString;
const schemaGeoPointLatLon = rt.type({
  lat: schemaNumber,
  lon: schemaNumber
});
const schemaGeoPointLocation = rt.type({
  location: schemaNumberArray
});
const schemaGeoPointLocationString = rt.type({
  location: schemaString
});
const schemaGeoPoint = exports.schemaGeoPoint = rt.union([schemaGeoPointCoords, schemaGeoPointString, schemaGeoPointLatLon, schemaGeoPointLocation, schemaGeoPointLocationString]);
const schemaGeoPointArray = exports.schemaGeoPointArray = rt.array(schemaGeoPoint);
// prettier-ignore
const AlertRequired = rt.type({
  '@timestamp': schemaDate,
  'kibana.alert.instance.id': schemaString,
  'kibana.alert.rule.category': schemaString,
  'kibana.alert.rule.consumer': schemaString,
  'kibana.alert.rule.name': schemaString,
  'kibana.alert.rule.producer': schemaString,
  'kibana.alert.rule.revision': schemaStringOrNumber,
  'kibana.alert.rule.rule_type_id': schemaString,
  'kibana.alert.rule.uuid': schemaString,
  'kibana.alert.status': schemaString,
  'kibana.alert.uuid': schemaString,
  'kibana.space_ids': schemaStringArray
});
// prettier-ignore
const AlertOptional = rt.partial({
  'event.action': schemaString,
  'event.kind': schemaString,
  'event.original': schemaString,
  'kibana.alert.action_group': schemaString,
  'kibana.alert.case_ids': schemaStringArray,
  'kibana.alert.consecutive_matches': schemaStringOrNumber,
  'kibana.alert.duration.us': schemaStringOrNumber,
  'kibana.alert.end': schemaDate,
  'kibana.alert.flapping': schemaBoolean,
  'kibana.alert.flapping_history': schemaBooleanArray,
  'kibana.alert.intended_timestamp': schemaDate,
  'kibana.alert.last_detected': schemaDate,
  'kibana.alert.maintenance_window_ids': schemaStringArray,
  'kibana.alert.pending_recovered_count': schemaStringOrNumber,
  'kibana.alert.previous_action_group': schemaString,
  'kibana.alert.reason': schemaString,
  'kibana.alert.rule.execution.timestamp': schemaDate,
  'kibana.alert.rule.execution.type': schemaString,
  'kibana.alert.rule.execution.uuid': schemaString,
  'kibana.alert.rule.parameters': schemaUnknown,
  'kibana.alert.rule.tags': schemaStringArray,
  'kibana.alert.severity_improving': schemaBoolean,
  'kibana.alert.start': schemaDate,
  'kibana.alert.time_range': schemaDateRange,
  'kibana.alert.updated_at': schemaDate,
  'kibana.alert.updated_by.user.id': schemaString,
  'kibana.alert.updated_by.user.name': schemaString,
  'kibana.alert.url': schemaString,
  'kibana.alert.workflow_assignee_ids': schemaStringArray,
  'kibana.alert.workflow_status': schemaString,
  'kibana.alert.workflow_tags': schemaStringArray,
  'kibana.version': schemaString,
  tags: schemaStringArray
});

// prettier-ignore
const AlertSchema = exports.AlertSchema = rt.intersection([AlertRequired, AlertOptional]);
// prettier-ignore