"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawAdHocRunParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQuery = require("@kbn/es-query");
var _v = require("./v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ISOWeekdaysSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6), _configSchema.schema.literal(7)]);
const rawRuleAlertsFilterSchema = _configSchema.schema.object({
  query: _configSchema.schema.maybe(_configSchema.schema.object({
    kql: _configSchema.schema.string(),
    filters: _configSchema.schema.arrayOf(_configSchema.schema.object({
      query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
      meta: _configSchema.schema.object({
        alias: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.string())),
        disabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        negate: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        controlledBy: _configSchema.schema.maybe(_configSchema.schema.string()),
        group: _configSchema.schema.maybe(_configSchema.schema.string()),
        index: _configSchema.schema.maybe(_configSchema.schema.string()),
        isMultiIndex: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        type: _configSchema.schema.maybe(_configSchema.schema.string()),
        key: _configSchema.schema.maybe(_configSchema.schema.string()),
        params: _configSchema.schema.maybe(_configSchema.schema.any()),
        value: _configSchema.schema.maybe(_configSchema.schema.string()),
        field: _configSchema.schema.maybe(_configSchema.schema.string()),
        relation: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('OR'), _configSchema.schema.literal('AND')]))
      }),
      $state: _configSchema.schema.maybe(_configSchema.schema.object({
        store: _configSchema.schema.oneOf([_configSchema.schema.literal(_esQuery.FilterStateStore.APP_STATE),
        // change
        _configSchema.schema.literal(_esQuery.FilterStateStore.GLOBAL_STATE) // change
        ])
      }))
    })),
    dsl: _configSchema.schema.string() // change
  })),
  timeframe: _configSchema.schema.maybe(_configSchema.schema.object({
    days: _configSchema.schema.arrayOf(ISOWeekdaysSchema),
    hours: _configSchema.schema.object({
      start: _configSchema.schema.string(),
      end: _configSchema.schema.string()
    }),
    timezone: _configSchema.schema.string()
  }))
});
const rawAdHocRunParamsRuleActionSchema = _configSchema.schema.object({
  uuid: _configSchema.schema.string(),
  group: _configSchema.schema.maybe(_configSchema.schema.string()),
  actionRef: _configSchema.schema.string(),
  actionTypeId: _configSchema.schema.string(),
  params: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
  frequency: _configSchema.schema.maybe(_configSchema.schema.object({
    summary: _configSchema.schema.boolean(),
    notifyWhen: _configSchema.schema.oneOf([_configSchema.schema.literal('onActionGroupChange'), _configSchema.schema.literal('onActiveAlert'), _configSchema.schema.literal('onThrottleInterval')]),
    throttle: _configSchema.schema.nullable(_configSchema.schema.string())
  })),
  alertsFilter: _configSchema.schema.maybe(rawRuleAlertsFilterSchema),
  useAlertDataForTemplate: _configSchema.schema.maybe(_configSchema.schema.boolean())
});
const rawAdHocRunParamsRuleSchema = _v.rawAdHocRunParamsRuleSchema.extends({
  actions: _configSchema.schema.maybe(_configSchema.schema.arrayOf(rawAdHocRunParamsRuleActionSchema))
});
const rawAdHocRunParamsSchema = exports.rawAdHocRunParamsSchema = _v.rawAdHocRunParamsSchema.extends({
  rule: rawAdHocRunParamsRuleSchema
});