"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.maintenanceWindowModelVersions = void 0;
var _raw_maintenance_window = require("../schemas/raw_maintenance_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const maintenanceWindowModelVersions = exports.maintenanceWindowModelVersions = {
  '1': {
    changes: [],
    schemas: {
      forwardCompatibility: _raw_maintenance_window.rawMaintenanceWindowSchemaV1.extends({}, {
        unknowns: 'ignore'
      }),
      create: _raw_maintenance_window.rawMaintenanceWindowSchemaV1
    }
  },
  '2': {
    changes: [{
      type: 'mappings_addition',
      addedMappings: {
        title: {
          type: 'text',
          fields: {
            keyword: {
              type: 'keyword'
            }
          }
        },
        expirationDate: {
          type: 'date'
        },
        updatedAt: {
          type: 'date'
        }
      }
    }],
    schemas: {
      forwardCompatibility: _raw_maintenance_window.rawMaintenanceWindowSchemaV1.extends({}, {
        unknowns: 'ignore'
      })
    }
  }
};