"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectReferencesIntoActions = injectReferencesIntoActions;
exports.injectReferencesIntoArtifacts = injectReferencesIntoArtifacts;
exports.injectReferencesIntoParams = injectReferencesIntoParams;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _lodash = require("lodash");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function injectReferencesIntoActions(alertId, actions, references) {
  return actions.map(action => {
    if (action.actionRef.startsWith(_constants.preconfiguredConnectorActionRefPrefix)) {
      return {
        ...(0, _lodash.omit)(action, 'actionRef'),
        id: action.actionRef.replace(_constants.preconfiguredConnectorActionRefPrefix, '')
      };
    }
    if (action.actionRef.startsWith(_constants.systemConnectorActionRefPrefix)) {
      return {
        ...(0, _lodash.omit)(action, 'actionRef'),
        id: action.actionRef.replace(_constants.systemConnectorActionRefPrefix, '')
      };
    }
    const reference = references.find(ref => ref.name === action.actionRef);
    if (!reference) {
      throw new Error(`Action reference "${action.actionRef}" not found in alert id: ${alertId}`);
    }
    return {
      ...(0, _lodash.omit)(action, 'actionRef'),
      id: reference.id
    };
  });
}
function injectReferencesIntoParams(ruleId, ruleType, ruleParams, references) {
  try {
    var _ruleType$useSavedObj;
    const paramReferences = references.filter(reference => reference.name.startsWith(_constants.extractedSavedObjectParamReferenceNamePrefix)).map(reference => ({
      ...reference,
      name: reference.name.replace(_constants.extractedSavedObjectParamReferenceNamePrefix, '')
    }));
    return ruleParams && ruleType !== null && ruleType !== void 0 && (_ruleType$useSavedObj = ruleType.useSavedObjectReferences) !== null && _ruleType$useSavedObj !== void 0 && _ruleType$useSavedObj.injectReferences ? ruleType.useSavedObjectReferences.injectReferences(ruleParams, paramReferences) : ruleParams;
  } catch (err) {
    throw _boom.default.badRequest(`Error injecting reference into rule params for rule id ${ruleId} - ${err.message}`);
  }
}
function injectReferencesIntoArtifacts(ruleId, artifacts, references) {
  var _artifacts$investigat, _artifacts$investigat2, _artifacts$dashboards, _artifacts$dashboards2;
  if (!artifacts) {
    return {
      dashboards: [],
      investigation_guide: {
        blob: ''
      }
    };
  }
  return {
    ...artifacts,
    investigation_guide: {
      blob: (_artifacts$investigat = (_artifacts$investigat2 = artifacts.investigation_guide) === null || _artifacts$investigat2 === void 0 ? void 0 : _artifacts$investigat2.blob) !== null && _artifacts$investigat !== void 0 ? _artifacts$investigat : ''
    },
    dashboards: (_artifacts$dashboards = (_artifacts$dashboards2 = artifacts.dashboards) === null || _artifacts$dashboards2 === void 0 ? void 0 : _artifacts$dashboards2.map(dashboard => {
      const reference = references === null || references === void 0 ? void 0 : references.find(ref => ref.name === dashboard.refId && ref.type === 'dashboard');
      if (!reference) {
        throw new Error(`Artifacts reference "${dashboard.refId}" not found in rule id: ${ruleId}`);
      }
      return {
        ...(0, _lodash.omit)(dashboard, 'refId'),
        id: reference.id
      };
    })) !== null && _artifacts$dashboards !== void 0 ? _artifacts$dashboards : []
  };
}