"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformGetResponse = void 0;
var _transforms = require("../../../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformGetResponse = (rule, includeArtifacts = false) => ({
  ...(0, _transforms.transformRuleToRuleResponseV1)(rule),
  ...(includeArtifacts && rule.artifacts !== undefined ? {
    artifacts: rule.artifacts
  } : {})
});
exports.transformGetResponse = transformGetResponse;