"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCategoryIds = void 0;
var _alert_delete = require("../../../../../common/constants/alert_delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCategoryIds = input => {
  if (!input) return [_alert_delete.alertDeleteCategoryIds.MANAGEMENT, _alert_delete.alertDeleteCategoryIds.SECURITY_SOLUTION, _alert_delete.alertDeleteCategoryIds.OBSERVABILITY];

  // Accepting single category id or array of category ids because
  // sending an array with just one element is decoded as a simple string
  return Array.isArray(input) ? input : [input];
};
exports.getCategoryIds = getCategoryIds;