"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertDeleteScheduleRoute = void 0;
var _constants = require("@kbn/spaces-plugin/common/constants");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _has_required_privilege_granted_in_all_spaces = require("../../../../lib/has_required_privilege_granted_in_all_spaces");
var _alert_delete = require("../../../../../common/routes/alert_delete");
var _types = require("../../../../types");
var _lib = require("../../../lib");
var _common = require("../../../../../common");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertDeleteScheduleRoute = (router, licenseState, core) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/settings/_alert_delete_schedule`,
    validate: {
      body: _alert_delete.alertDeleteScheduleQuerySchemaV1
    },
    security: {
      authz: {
        requiredPrivileges: [`${_common.API_PRIVILEGES.WRITE_ALERT_DELETE_SETTINGS}`]
      }
    },
    options: {
      access: 'internal'
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const {
      spaceIds,
      ...settings
    } = (0, _transforms.transformRequestToAlertDeleteScheduleV1)(req.body);
    if (spaceIds && spaceIds.length > 0) {
      const [, {
        security
      }] = await core.getStartServices();
      const hasRequiredPrivilegeGranted = await (0, _has_required_privilege_granted_in_all_spaces.hasRequiredPrivilegeGrantedInAllSpaces)({
        request: req,
        spaceIds,
        requiredPrivilege: _common.API_PRIVILEGES.WRITE_ALERT_DELETE_SETTINGS,
        authz: security === null || security === void 0 ? void 0 : security.authz
      });
      if (!hasRequiredPrivilegeGranted) {
        throw _boom.default.forbidden('Insufficient privileges to delete alerts in the specified spaces');
      }
    }
    if (!settings.isActiveAlertDeleteEnabled && !settings.isInactiveAlertDeleteEnabled) {
      return res.badRequest({
        body: {
          message: 'active_alert_delete_threshold or inactive_alert_delete_threshold must be set'
        }
      });
    }
    try {
      const message = await alertingContext.getAlertDeletionClient().scheduleTask(req, settings, spaceIds && spaceIds.length > 0 ? spaceIds : [(await alertingContext.getRulesClient()).getSpaceId() || _constants.DEFAULT_SPACE_ID]);
      return message ? res.ok({
        body: message
      }) : res.noContent();
    } catch (error) {
      return res.customError({
        statusCode: 500,
        body: {
          message: error.message
        }
      });
    }
  })));
};
exports.alertDeleteScheduleRoute = alertDeleteScheduleRoute;