"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toRawAlertInstances = toRawAlertInstances;
var _lodash = require("lodash");
var _optimize_task_state_for_flapping = require("./flapping/optimize_task_state_for_flapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toRawAlertInstances(logger, maxAlerts, activeAlerts = {}, recoveredAlerts = {}, shouldOptimizeTaskState = false) {
  const rawActiveAlerts = {};
  const rawRecoveredAlerts = {};
  for (const id of (0, _lodash.keys)(activeAlerts)) {
    rawActiveAlerts[id] = activeAlerts[id].toRaw();
  }
  if (shouldOptimizeTaskState) {
    recoveredAlerts = (0, _optimize_task_state_for_flapping.optimizeTaskStateForFlapping)(logger, recoveredAlerts, maxAlerts);
  }
  for (const id of (0, _lodash.keys)(recoveredAlerts)) {
    rawRecoveredAlerts[id] = recoveredAlerts[id].toRaw(true);
  }
  return {
    rawActiveAlerts,
    rawRecoveredAlerts
  };
}