"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleNotifyWhen = exports.ruleLastRunOutcomeValues = exports.ruleExecutionStatusWarningReason = exports.ruleExecutionStatusValues = exports.ruleExecutionStatusErrorReason = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleNotifyWhen = exports.ruleNotifyWhen = {
  CHANGE: 'onActionGroupChange',
  ACTIVE: 'onActiveAlert',
  THROTTLE: 'onThrottleInterval'
};
const ruleLastRunOutcomeValues = exports.ruleLastRunOutcomeValues = {
  SUCCEEDED: 'succeeded',
  WARNING: 'warning',
  FAILED: 'failed'
};
const ruleExecutionStatusValues = exports.ruleExecutionStatusValues = {
  OK: 'ok',
  ACTIVE: 'active',
  ERROR: 'error',
  WARNING: 'warning',
  PENDING: 'pending',
  UNKNOWN: 'unknown'
};
const ruleExecutionStatusErrorReason = exports.ruleExecutionStatusErrorReason = {
  READ: 'read',
  DECRYPT: 'decrypt',
  EXECUTE: 'execute',
  UNKNOWN: 'unknown',
  LICENSE: 'license',
  TIMEOUT: 'timeout',
  DISABLED: 'disabled',
  VALIDATE: 'validate'
};
const ruleExecutionStatusWarningReason = exports.ruleExecutionStatusWarningReason = {
  MAX_EXECUTABLE_ACTIONS: 'maxExecutableActions',
  MAX_ALERTS: 'maxAlerts',
  MAX_QUEUED_ACTIONS: 'maxQueuedActions',
  EXECUTION: 'ruleExecution'
};