"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQuery = require("@kbn/react-query");
var _common = require("../../common");
var _use_license = require("../hooks/use_license");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MaintenanceWindowsLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pages/maintenance_windows'))));
const MaintenanceWindowsCreateLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pages/maintenance_windows/maintenance_window_create_page'))));
const MaintenanceWindowsEditLazy = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../pages/maintenance_windows/maintenance_window_edit_page'))));
const App = /*#__PURE__*/_react.default.memo(() => {
  const {
    isAtLeastPlatinum
  } = (0, _use_license.useLicense)();
  const hasLicense = isAtLeastPlatinum();
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, hasLicense ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: _common.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsCreate,
    path: _common.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsCreate,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(MaintenanceWindowsCreateLazy, null))) : null, hasLicense ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: _common.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsEdit,
    path: _common.MAINTENANCE_WINDOW_PATHS.alerting.maintenanceWindowsEdit,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(MaintenanceWindowsEditLazy, null))) : null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(MaintenanceWindowsLazy, null))));
});
App.displayName = 'App';
const renderApp = ({
  core,
  plugins,
  mountParams,
  kibanaVersion
}) => {
  const {
    element,
    history
  } = mountParams;
  const queryClient = new _reactQuery.QueryClient();
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public2.Storage(localStorage),
      kibanaVersion
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(App, null))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;