"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTagsAggregation = exports.formatRuleTagsAggregationResult = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleTagsAggregation = params => {
  const {
    maxTags = 50,
    after
  } = params || {};
  return {
    tags: {
      composite: {
        ...(after ? {
          after
        } : {}),
        size: maxTags,
        sources: [{
          tags: {
            terms: {
              field: 'alert.attributes.tags',
              order: 'asc'
            }
          }
        }]
      }
    }
  };
};
exports.getRuleTagsAggregation = getRuleTagsAggregation;
const formatRuleTagsAggregationResult = aggregations => {
  if (!aggregations) {
    return {
      ruleTags: []
    };
  }
  const tagsBuckets = aggregations.tags.buckets || [];
  return {
    ruleTags: tagsBuckets.map(bucket => bucket.key.tags)
  };
};
exports.formatRuleTagsAggregationResult = formatRuleTagsAggregationResult;