"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGapsSummaryByRuleIdsResponseSchema = exports.getGapsSummaryByRuleIdsBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getGapsSummaryByRuleIdsBodySchema = exports.getGapsSummaryByRuleIdsBodySchema = _configSchema.schema.object({
  end: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  rule_ids: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    maxSize: 100
  })
}, {
  validate({
    start,
    end
  }) {
    const parsedStart = Date.parse(start);
    if (isNaN(parsedStart)) {
      return `[start]: query start must be valid date`;
    }
    const parsedEnd = Date.parse(end);
    if (isNaN(parsedEnd)) {
      return `[end]: query end must be valid date`;
    }
    if (parsedStart >= parsedEnd) {
      return `[start]: query start must be before end`;
    }
  }
});
const getGapsSummaryByRuleIdsResponseSchema = exports.getGapsSummaryByRuleIdsResponseSchema = _configSchema.schema.object({
  data: _configSchema.schema.arrayOf(_configSchema.schema.object({
    rule_id: _configSchema.schema.string(),
    total_unfilled_duration_ms: _configSchema.schema.number(),
    total_in_progress_duration_ms: _configSchema.schema.number(),
    total_filled_duration_ms: _configSchema.schema.number()
  }))
});