"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findGapsResponseSchema = exports.findGapsBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _response = require("../../../response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findGapsBodySchema = exports.findGapsBodySchema = _configSchema.schema.object({
  end: _configSchema.schema.string(),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  per_page: _configSchema.schema.number({
    defaultValue: 10,
    min: 1,
    max: 10000
  }),
  rule_id: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  sort_field: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('@timestamp'), _configSchema.schema.literal('kibana.alert.rule.gap.status'), _configSchema.schema.literal('kibana.alert.rule.gap.total_gap_duration_ms')])),
  sort_order: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  statuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('partially_filled'), _configSchema.schema.literal('unfilled'), _configSchema.schema.literal('filled')])))
}, {
  validate({
    start,
    end
  }) {
    const parsedStart = Date.parse(start);
    const parsedEnd = Date.parse(end);
    if (start) {
      if (isNaN(parsedStart)) {
        return `[start]: query start must be valid date`;
      }
    }
    if (end) {
      if (isNaN(parsedEnd)) {
        return `[end]: query end must be valid date`;
      }
    }
    if (parsedStart >= parsedEnd) {
      return `[start]: query start must be before end`;
    }
  }
});
const findGapsResponseSchema = exports.findGapsResponseSchema = _configSchema.schema.object({
  page: _configSchema.schema.number(),
  per_page: _configSchema.schema.number(),
  total: _configSchema.schema.number(),
  data: _configSchema.schema.arrayOf(_response.gapsResponseSchemaV1)
});