"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processDocumentCountStats = exports.getDocumentCountStatsRequest = void 0;
var _lodash = require("lodash");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _aiopsLogRateAnalysis = require("@kbn/aiops-log-rate-analysis");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _build_extended_base_filter_criteria = require("./application/utils/build_extended_base_filter_criteria");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDocumentCountStatsRequest = (params, randomSamplerWrapper, skipAggs = false, changePoints = false) => {
  const {
    index,
    timeFieldName,
    earliest: earliestMs,
    latest: latestMs,
    runtimeFieldMap,
    searchQuery,
    intervalMs,
    fieldsToFetch,
    selectedSignificantItem,
    includeSelectedSignificantItem,
    selectedGroup,
    trackTotalHits
  } = params;
  const filterCriteria = (0, _build_extended_base_filter_criteria.buildExtendedBaseFilterCriteria)(timeFieldName, earliestMs, latestMs, searchQuery, selectedSignificantItem, includeSelectedSignificantItem, selectedGroup);
  const rawAggs = {
    eventRate: {
      date_histogram: {
        field: timeFieldName,
        fixed_interval: `${intervalMs}ms`,
        min_doc_count: 0,
        ...(earliestMs !== undefined && latestMs !== undefined ? {
          extended_bounds: {
            min: earliestMs,
            max: latestMs
          }
        } : {})
      }
    },
    ...(changePoints ? {
      change_point_request: {
        // @ts-expect-error missing from ES spec
        change_point: {
          buckets_path: 'eventRate>_count'
        }
      }
    } : {})
  };
  const aggs = randomSamplerWrapper ? randomSamplerWrapper.wrap(rawAggs) : rawAggs;
  const searchBody = {
    query: {
      bool: {
        filter: filterCriteria
      }
    },
    track_total_hits: trackTotalHits === true,
    size: 0
  };
  if ((0, _mlIsPopulatedObject.isPopulatedObject)(runtimeFieldMap)) {
    searchBody.runtime_mappings = runtimeFieldMap;
  }
  if (!fieldsToFetch && !skipAggs && timeFieldName !== undefined && intervalMs !== undefined && intervalMs > 0) {
    searchBody.aggs = aggs;
    searchBody.sort = {
      [timeFieldName]: 'desc'
    };
    searchBody.fields = [timeFieldName];
    searchBody.size = 1;
  }
  return {
    index,
    body: searchBody
  };
};
exports.getDocumentCountStatsRequest = getDocumentCountStatsRequest;
const processDocumentCountStats = (body, params, randomSamplerWrapper) => {
  var _ref, _value, _body$hits$hits$0$fie, _body$hits$hits$, _dateMath$parse;
  if (!body) return undefined;
  const totalCount = (_ref = (_value = body.hits.total.value) !== null && _value !== void 0 ? _value : body.hits.total) !== null && _ref !== void 0 ? _ref : 0;
  if (params.intervalMs === undefined || params.earliest === undefined || params.latest === undefined) {
    return {
      totalCount
    };
  }
  const dataByTimeBucket = (0, _lodash.get)(randomSamplerWrapper && body.aggregations !== undefined ? randomSamplerWrapper.unwrap(body.aggregations) : body.aggregations, ['eventRate', 'buckets'], []);
  const changePointRaw = (0, _lodash.get)(randomSamplerWrapper && body.aggregations !== undefined ? randomSamplerWrapper.unwrap(body.aggregations) : body.aggregations, ['change_point_request']);
  const changePointBase = changePointRaw && changePointRaw.bucket && Object.keys(changePointRaw.type).length > 0 ? {
    key: Date.parse(changePointRaw.bucket.key),
    type: Object.keys(changePointRaw.type)[0]
  } : undefined;
  const buckets = dataByTimeBucket.reduce((acc, cur) => {
    acc[cur.key] = cur.doc_count;
    return acc;
  }, {});
  const lastDocTimeStamp = Object.values((_body$hits$hits$0$fie = (_body$hits$hits$ = body.hits.hits[0]) === null || _body$hits$hits$ === void 0 ? void 0 : _body$hits$hits$.fields) !== null && _body$hits$hits$0$fie !== void 0 ? _body$hits$hits$0$fie : [[]])[0][0];
  const lastDocTimeStampMs = lastDocTimeStamp === undefined ? undefined : (_dateMath$parse = _datemath.default.parse(lastDocTimeStamp)) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.valueOf();
  return {
    interval: params.intervalMs,
    buckets,
    timeRangeEarliest: params.earliest,
    timeRangeLatest: params.latest,
    totalCount,
    lastDocTimeStampMs,
    ...(changePointBase ? {
      changePoint: {
        ...changePointBase,
        ...(0, _aiopsLogRateAnalysis.getExtendedChangePoint)(buckets, changePointBase === null || changePointBase === void 0 ? void 0 : changePointBase.key)
      }
    } : {})
  };
};
exports.processDocumentCountStats = processDocumentCountStats;