"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRandomSamplerStorage = useRandomSamplerStorage;
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlRandomSamplerUtils = require("@kbn/ml-random-sampler-utils");
var _storage = require("../../../types/storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useRandomSamplerStorage() {
  const [randomSamplerMode, setRandomSamplerMode] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_RANDOM_SAMPLING_MODE_PREFERENCE, _mlRandomSamplerUtils.RANDOM_SAMPLER_OPTION.ON_AUTOMATIC);
  const [randomSamplerProbability, setRandomSamplerProbability] = (0, _mlLocalStorage.useStorage)(_storage.AIOPS_RANDOM_SAMPLING_PROBABILITY_PREFERENCE, _mlRandomSamplerUtils.DEFAULT_PROBABILITY);
  return {
    randomSamplerMode,
    setRandomSamplerMode,
    randomSamplerProbability,
    setRandomSamplerProbability
  };
}