"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldValuePairCounts = getFieldValuePairCounts;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get a nested record of field/value pairs with counts
 */
function getFieldValuePairCounts(cpgs) {
  return cpgs.reduce((p, {
    group
  }) => {
    group.forEach(({
      fieldName,
      fieldValue
    }) => {
      if (p[fieldName] === undefined) {
        p[fieldName] = Object.create(null);
      }
      p[fieldName][fieldValue] = p[fieldName][fieldValue] ? p[fieldName][fieldValue] + 1 : 1;
    });
    return p;
  }, {});
}