"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionExecutions = getActionExecutions;
exports.getActions = getActions;
exports.getActionsCount = getActionsCount;
exports.getInMemoryActions = getInMemoryActions;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInMemoryActions(aggregation = []) {
  const preconfiguredActionsAggs = {
    total: 0,
    actionRefs: {}
  };
  const systemActionsAggs = {
    total: 0,
    actionRefs: {}
  };
  for (const a of aggregation) {
    const actionRef = a.key[0];
    const actionTypeId = a.key[1];
    if (actionRef.startsWith('preconfigured:')) {
      preconfiguredActionsAggs.actionRefs[actionRef] = {
        actionRef,
        actionTypeId
      };
      preconfiguredActionsAggs.total++;
    }
    if (actionRef.startsWith('system_action:')) {
      systemActionsAggs.actionRefs[actionRef] = {
        actionRef,
        actionTypeId
      };
      systemActionsAggs.total++;
    }
  }
  return {
    preconfiguredActionsAggs,
    systemActionsAggs
  };
}
function getActions(aggregation = []) {
  const actions = {
    total: 0,
    connectorIds: {}
  };
  for (const a of aggregation) {
    const connectorId = a.key[0];
    const actionRef = a.key[1];
    if (actionRef.startsWith('dashboard')) continue;
    actions.connectorIds[connectorId] = actionRef;
    actions.total++;
  }
  return actions;
}
function getActionExecutions(aggregation = []) {
  const executions = {
    total: 0,
    connectorTypes: {}
  };
  for (const a of aggregation) {
    executions.connectorTypes[a.key] = a.doc_count;
    executions.total += a.doc_count;
  }
  return executions;
}
function getActionsCount(aggregation = []) {
  const actions = {};
  for (const a of aggregation) {
    actions[a.key] = a.doc_count;
  }
  return actions;
}