"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorUsageCollector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ConnectorUsageCollector {
  constructor({
    logger,
    connectorId
  }) {
    (0, _defineProperty2.default)(this, "connectorId", void 0);
    (0, _defineProperty2.default)(this, "usage", {
      requestBodyBytes: 0
    });
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger;
    this.connectorId = connectorId;
  }
  addRequestBodyBytes(result, body = '') {
    var _result$request;
    const contentLength = result === null || result === void 0 ? void 0 : (_result$request = result.request) === null || _result$request === void 0 ? void 0 : _result$request.getHeader('content-length');
    let bytes = 0;
    if (!(0, _lodash.isUndefined)(contentLength)) {
      bytes = parseInt(contentLength, 10);
    } else {
      try {
        const sBody = typeof body === 'string' ? body : JSON.stringify(body);
        bytes = Buffer.byteLength(sBody, 'utf8');
      } catch (e) {
        this.logger.error(`Request body bytes couldn't be calculated, Error: ${e.message}, connectorId:${this.connectorId}`);
      }
    }
    this.usage.requestBodyBytes = this.usage.requestBodyBytes + bytes;
  }
  getRequestBodyByte() {
    return this.usage.requestBodyBytes;
  }
}
exports.ConnectorUsageCollector = ConnectorUsageCollector;