"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformExecuteConnectorResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformExecuteConnectorResponse = ({
  actionId,
  retry,
  serviceMessage,
  ...res
}) => ({
  ...res,
  connector_id: actionId,
  ...(retry && retry instanceof Date ? {
    retry: retry.toISOString()
  } : {
    retry
  }),
  ...(serviceMessage ? {
    service_message: serviceMessage
  } : {})
});
exports.transformExecuteConnectorResponse = transformExecuteConnectorResponse;