"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiPaddingSize = exports.useEuiPaddingCSS = exports.euiPaddingSize = exports.PADDING_SIZES = void 0;
var _react = require("@emotion/react");
var _theme = require("../../services/theme");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var PADDING_SIZES = exports.PADDING_SIZES = ['none', 'xs', 's', 'm', 'l', 'xl'];
/**
 * Get a single padding size
 */

var euiPaddingSize = exports.euiPaddingSize = function euiPaddingSize(_ref, size) {
  var euiTheme = _ref.euiTheme;
  switch (size) {
    case 'none':
      return null;
    case 'm':
      return euiTheme.size.base;
    default:
      return euiTheme.size[size];
  }
};

/**
 * @returns An object map of padding size keys to padding values,
 * e.g. { s: '8px', m: '16px', ... }
 */
var _getEuiPaddingSize = function _getEuiPaddingSize(euiThemeContext) {
  return PADDING_SIZES.reduce(function (stylesAcc, size) {
    return _objectSpread(_objectSpread({}, stylesAcc), {}, _defineProperty({}, size, size === 'none' ? null : euiPaddingSize(euiThemeContext, size)));
  }, {});
};
var useEuiPaddingSize = exports.useEuiPaddingSize = function useEuiPaddingSize(size) {
  var sizes = (0, _theme.useEuiMemoizedStyles)(_getEuiPaddingSize);
  return sizes[size];
};

/**
 * @returns An object map of all padding sizes for all padding sides properties
 * e.g., {
 *   padding: { s: css`padding-size: 8px`, ... }
 *   left: { s: css`padding-inline-start: 8px`, ... }
 * }
 */
var _euiPaddingSidesAndSizes = function _euiPaddingSidesAndSizes(euiThemeContext) {
  var sizesMap = _getEuiPaddingSize(euiThemeContext);
  // The `_` prefix stops Emotion from applying the function name as a label
  var _generateSizeStyles = function _generateSizeStyles(cssProperty) {
    return Object.fromEntries(Object.entries(sizesMap).map(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        sizeKey = _ref3[0],
        sizeValue = _ref3[1];
      return [sizeKey, sizeValue === null ? null : /*#__PURE__*/(0, _react.css)(cssProperty, ":", sizeValue, ";label:", sizeKey, ";")];
    }));
  };
  var sidesMap = {
    padding: _generateSizeStyles('padding'),
    vertical: _generateSizeStyles('padding-block'),
    top: _generateSizeStyles('padding-block-start'),
    bottom: _generateSizeStyles('padding-block-end'),
    horizontal: _generateSizeStyles('padding-inline'),
    left: _generateSizeStyles('padding-inline-start'),
    right: _generateSizeStyles('padding-inline-end')
  };
  return sidesMap;
};
var useEuiPaddingCSS = exports.useEuiPaddingCSS = function useEuiPaddingCSS(side) {
  var memoizedSideMap = (0, _theme.useEuiMemoizedStyles)(_euiPaddingSidesAndSizes);
  return memoizedSideMap[side || 'padding'];
};