"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTipArrow = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _tool_tip = require("./tool_tip.styles");
var _react2 = require("@emotion/react");
var _excluded = ["position"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiToolTipArrow = exports.EuiToolTipArrow = function EuiToolTipArrow(_ref) {
  var position = _ref.position,
    props = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _tool_tip.euiToolTipStyles)(euiTheme);
  var cssStyles = [styles.euiToolTip__arrow, styles.arrowPositions[position]];
  return (0, _react2.jsx)("div", _extends({
    css: cssStyles
  }, props));
};
EuiToolTipArrow.propTypes = {
  position: _propTypes.default.oneOf(["top", "right", "bottom", "left"]).isRequired
};