"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiToastStyles = exports.euiToastHeaderStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _title = require("../title/title.styles");
var _panel = require("../panel/panel.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiToastStyles = exports.euiToastStyles = function euiToastStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var highlightStyles = function highlightStyles(color, width) {
    return "\n    &:before {\n      content: '';\n      position: absolute;\n      /* ensure highlight border is on top of panel border */\n      z-index: 1;\n      inset: 0;\n      border-radius: inherit;\n      ".concat((0, _global_styling.logicalCSS)('border-top', "".concat(width, " solid ").concat(color)), "\n      pointer-events: none;\n    }\n  ");
  };
  return {
    // Base
    euiToast: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";", (0, _euiThemeCommon.euiShadowLarge)(euiThemeContext, {
      borderAllInHighContrastMode: true
    }), " position:relative;", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.base), " background-color:", euiTheme.colors.emptyShade, ";", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.euiTextBreakWord)(), (0, _panel.euiPanelBorderStyles)(euiThemeContext, {
      hasFloatingBorder: false
    }), " &:hover,&:focus{[class*='euiToast__closeButton']{opacity:1;}};label:euiToast;"),
    // Elements
    euiToast__closeButton: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('top', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('right', euiTheme.size.base), ";;label:euiToast__closeButton;"),
    // Variants
    colors: {
      _getStyles: function _getStyles(color) {
        // Increase color/border thickness for all high contrast modes
        var borderWidth = highContrastMode ? (0, _euiThemeCommon.mathWithUnits)(euiTheme.border.width.thick, function (x) {
          return x * 2;
        }) : euiTheme.border.width.thick;
        return (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
          none: highlightStyles(color, borderWidth),
          preferred: "\n            ".concat(highlightStyles(color, borderWidth), "\n            \n            &::before {\n              ").concat((0, _global_styling.logicalCSS)('width', "calc(100% + ".concat((0, _euiThemeCommon.mathWithUnits)(euiTheme.border.width.thin, function (x) {
            return x * 2;
          }), ")")), "\n              ").concat((0, _global_styling.logicalCSS)('margin-top', "-".concat(euiTheme.border.width.thin)), "\n              ").concat((0, _global_styling.logicalCSS)('margin-left', "-".concat(euiTheme.border.width.thin)), "\n            }\n          "),
          // Windows high contrast mode ignores/overrides border colors, which have semantic meaning here. To get around this, we'll use a pseudo element that ignores forced colors
          forced: "\n            overflow: hidden;\n\n            &::before {\n              content: '';\n              position: absolute;\n              ".concat((0, _global_styling.logicalCSS)('top', 0), "\n              ").concat((0, _global_styling.logicalCSS)('horizontal', 0), "\n              ").concat((0, _global_styling.logicalCSS)('height', borderWidth), "\n              background-color: ").concat(color, ";\n              ").concat((0, _high_contrast.preventForcedColors)(euiThemeContext), "\n              pointer-events: none;\n            }\n          ")
        });
      },
      get primary() {
        return /*#__PURE__*/(0, _react.css)(this._getStyles(euiTheme.colors.primary), ";label:primary;");
      },
      get success() {
        return /*#__PURE__*/(0, _react.css)(this._getStyles(euiTheme.colors.success), ";label:success;");
      },
      get warning() {
        return /*#__PURE__*/(0, _react.css)(this._getStyles(euiTheme.colors.warning), ";label:warning;");
      },
      get danger() {
        return /*#__PURE__*/(0, _react.css)(this._getStyles(euiTheme.colors.danger), ";label:danger;");
      }
    }
  };
};
var euiToastHeaderStyles = exports.euiToastHeaderStyles = function euiToastHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiToastHeader: /*#__PURE__*/(0, _react.css)("display:flex;align-items:baseline;", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.l), ">*+*{", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.s), ";};label:euiToastHeader;"),
    // Elements
    euiToastHeader__icon: /*#__PURE__*/(0, _react.css)("flex:0 0 auto;fill:", euiTheme.colors.textHeading, ";transform:translateY(2px);;label:euiToastHeader__icon;"),
    euiToastHeader__title: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.bold, ";;label:euiToastHeader__title;"),
    // Variants
    withBody: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:withBody;")
  };
};