"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiStepNumberStyles = exports.euiStepNumberContentStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _step = require("./step.styles");
var _mixins = require("../../global_styling/mixins");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1ru1jeq-euiStepNumber",
  styles: "flex-shrink:0;label:euiStepNumber;"
} : {
  name: "1ru1jeq-euiStepNumber",
  styles: "flex-shrink:0;label:euiStepNumber;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiStepNumberStyles = exports.euiStepNumberStyles = function euiStepNumberStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var euiStep = (0, _step.euiStepVariables)(euiTheme);
  var createStepsNumber = function createStepsNumber(size, fontSize) {
    return "\n      display: flex;\n      justify-content: center;\n      align-items: center;\n      ".concat((0, _global_styling.logicalCSS)('width', size), ";\n      ").concat((0, _global_styling.logicalCSS)('height', size), ";\n      font-size: ").concat(fontSize, ";\n      font-weight: ").concat(euiTheme.font.weight.medium, ";\n      color: ").concat(euiTheme.colors.emptyShade, ";\n      background-color: ").concat(euiTheme.colors.primary, ";\n      border-radius: 50%;\n      ").concat((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      preferred: "border: ".concat(euiTheme.border.thick, ";")
    }), "\n    ");
  };

  // euiButtonColor utils add colored borders in high contrast mode, but
  // we want to set our own standardized border instead
  var unsetButtonBorder = function unsetButtonBorder(buttonStyles) {
    return _objectSpread(_objectSpread({}, buttonStyles), {}, {
      border: undefined
    });
  };
  return {
    euiStepNumber: _ref,
    // sizes
    m: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberSize, (0, _global_styling.euiFontSizeFromScale)('s', euiTheme)), ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberSize, (0, _global_styling.euiFontSizeFromScale)('s', euiTheme)), ";;label:s;"),
    xs: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberXSSize, (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme)), ";;label:xs;"),
    none: /*#__PURE__*/(0, _react.css)(createStepsNumber(euiStep.numberXXSSize, (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme)), ";;label:none;"),
    // status
    incomplete: /*#__PURE__*/(0, _react.css)("background-color:transparent;color:", euiTheme.colors.textParagraph, ";border:", euiTheme.border.thick, ";;label:incomplete;"),
    disabled: /*#__PURE__*/(0, _react.css)((0, _mixins.euiButtonFillColor)(euiThemeContext, 'disabled'), " ", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      forced: 'opacity: 0.5;'
    }), ";;label:disabled;"),
    loading: /*#__PURE__*/(0, _react.css)("background:transparent;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      preferred: 'border: none;'
    }), ";;label:loading;"),
    warning: /*#__PURE__*/(0, _react.css)(unsetButtonBorder((0, _mixins.euiButtonFillColor)(euiThemeContext, 'warning')), " ", _global_styling.euiCanAnimate, "{animation:", _global_styling.euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)(unsetButtonBorder((0, _mixins.euiButtonFillColor)(euiThemeContext, 'danger')), " ", _global_styling.euiCanAnimate, "{animation:", _global_styling.euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:danger;"),
    complete: /*#__PURE__*/(0, _react.css)(unsetButtonBorder((0, _mixins.euiButtonFillColor)(euiThemeContext, 'success')), " ", _global_styling.euiCanAnimate, "{animation:", _global_styling.euiAnimScale, " ", euiTheme.animation.fast, " ", euiTheme.animation.bounce, ";};label:complete;"),
    current: /*#__PURE__*/(0, _react.css)("transform:scale(1.1);box-shadow:inset 0 0 0 ", euiTheme.border.width.thick, " ", euiTheme.colors.emptyShade, ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          border: ".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.primary, ";\n        "),
      // !important overrides horizontal steps' euiOutline usage. The extra offset
      // is here to helps reduce subpixel gaps between the outline and the border
      preferred: "\n          border-width: ".concat(euiTheme.border.width.thick, ";\n          outline-offset: -").concat(euiTheme.border.width.thin, " !important;\n        "),
      // For Windows forced color themes, just invert the background/foreground colors
      forced: "\n          color: ".concat(euiTheme.colors.emptyShade, ";\n          background-color: ").concat(euiTheme.colors.fullShade, ";\n          ").concat((0, _high_contrast.preventForcedColors)(euiThemeContext), "\n        ")
    }), ";;label:current;")
  };
};
var euiStepNumberContentStyles = exports.euiStepNumberContentStyles = function euiStepNumberContentStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    // Statuses with icon content
    euiStepNumber__icon: /*#__PURE__*/(0, _react.css)(";label:euiStepNumber__icon;"),
    complete: /*#__PURE__*/(0, _react.css)("stroke:currentColor;stroke-width:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x / 2;
    }), ";;label:complete;"),
    danger: /*#__PURE__*/(0, _react.css)("stroke:currentColor;stroke-width:", (0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return x / 2;
    }), ";;label:danger;"),
    warning: {
      // Slight extra offset for visual balance. Intentionally uses static px and not tokens
      m: "margin-block-start: -2px;",
      s: "margin-block-start: -2px;",
      xs: "margin-block-start: -1px;",
      none: "margin-block-start: -0.5px;"
    },
    // Title sizes
    none: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(euiTheme.size.s), ";label:none;")
  };
};