"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSplitPanelOuterStyles = exports.euiSplitPanelInnerStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _high_contrast = require("../../../global_styling/functions/high_contrast");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiSplitPanelOuterStyles = exports.euiSplitPanelOuterStyles = {
  euiSplitPanelOuter: /*#__PURE__*/(0, _react.css)("display:flex;", (0, _global_styling.logicalCSS)('min-width', 0), " overflow:hidden;;label:euiSplitPanelOuter;"),
  column: process.env.NODE_ENV === "production" ? {
    name: "ll8kmq-column",
    styles: "flex-direction:column;label:column;"
  } : {
    name: "ll8kmq-column",
    styles: "flex-direction:column;label:column;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  },
  row: process.env.NODE_ENV === "production" ? {
    name: "15mvjmo-row",
    styles: "flex-direction:row;label:row;"
  } : {
    name: "15mvjmo-row",
    styles: "flex-direction:row;label:row;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1k62yu6-euiSplitPanelInner",
  styles: "flex-basis:0%;transform:none!important;box-shadow:none!important;label:euiSplitPanelInner;"
} : {
  name: "1k62yu6-euiSplitPanelInner",
  styles: "flex-basis:0%;transform:none!important;box-shadow:none!important;label:euiSplitPanelInner;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSplitPanelInnerStyles = exports.euiSplitPanelInnerStyles = function euiSplitPanelInnerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSplitPanelInner: _ref,
    highContrastBorders: {
      // Don't double up on borders in high contrast mode, but render
      // border dividers between nested inner panels
      _renderBorder: function _renderBorder(direction) {
        return (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
          preferred: "\n            border: none;\n\n            &:not(:last-child) {\n              ".concat((0, _global_styling.logicalCSS)("border-".concat(direction), euiTheme.border.thin), "\n              border-color: inherit; /* Attempt to inherit from parent panel */\n            }\n          ")
        });
      },
      get column() {
        return this._renderBorder('bottom');
      },
      get row() {
        return this._renderBorder('right');
      }
    }
  };
};