"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._EuiPageEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _empty_prompt = require("../../empty_prompt");
var _page_section = require("../../page/page_section");
var _react2 = require("@emotion/react");
var _excluded = ["children", "alignment", "restrictWidth", "paddingSize", "grow", "panelled", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var _EuiPageEmptyPrompt = exports._EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(_ref) {
  var children = _ref.children,
    _ref$alignment = _ref.alignment,
    alignment = _ref$alignment === void 0 ? 'center' : _ref$alignment,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    panelled = _ref.panelled,
    color = _ref.color,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * If panelled = true, then either the section or empty prompt must be plain;
   * If color is anything but plain, then it must be the section that is plain;
   * If panelled = true, but color is undefined, then default to the empty prompt being plain;
   */

  var sectionColor;
  var emptyPromptColor;
  if (panelled && color === undefined) {
    sectionColor = 'plain';
    emptyPromptColor = 'subdued';
  } else if (panelled && color !== 'plain') {
    sectionColor = 'plain';
    emptyPromptColor = color;
  } else {
    sectionColor = 'transparent';
    emptyPromptColor = color || 'plain';
  }
  return (0, _react2.jsx)(_page_section.EuiPageSection, {
    paddingSize: paddingSize,
    color: sectionColor,
    grow: grow,
    restrictWidth: restrictWidth,
    alignment: alignment
  }, (0, _react2.jsx)(_empty_prompt.EuiEmptyPrompt
  // @ts-expect-error Hasn't been updated to use all the new values yet
  , _extends({
    paddingSize: paddingSize,
    color: emptyPromptColor,
    body: children
  }, rest)));
};
_EuiPageEmptyPrompt.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
       * Background color of the section;
       * Usually a lightened form of the brand colors
       */
  color: _propTypes.default.any,
  /**
       * Padding for all four sides
       */
  paddingSize: _propTypes.default.any,
  /**
       * Horizontal and/or vertical alignment of the section contents
       */
  alignment: _propTypes.default.any,
  /**
       * When true the panel will grow in height to fill container if parent is a flex group
       */
  grow: _propTypes.default.bool,
  /**
       * Passed down to the div wrapper of the section contents
       */
  contentProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }),
  /**
       * Sets which HTML element to render.
       */
  component: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.elementType.isRequired]),
  panelled: _propTypes.default.bool
};