"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPageSidebarStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "wtyx0k-euiPageSidebar",
  styles: "flex:0 1 0%;label:euiPageSidebar;"
} : {
  name: "wtyx0k-euiPageSidebar",
  styles: "flex:0 1 0%;label:euiPageSidebar;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiPageSidebarStyles = exports.euiPageSidebarStyles = function euiPageSidebarStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var embellishColor = (0, _services.transparentize)(euiTheme.colors.lightShade, 0.3);
  return {
    euiPageSidebar: _ref,
    sticky: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiYScroll)(euiThemeContext, {
      height: 'auto'
    }), " flex-grow:1;position:sticky;;label:sticky;"),
    embellish: /*#__PURE__*/(0, _react.css)("background:linear-gradient(\n          160deg,\n          ", embellishColor, " 0,\n          ", embellishColor, " ", euiTheme.size.xl, ",\n          transparent 0\n        ),linear-gradient(\n          175deg,\n          ", embellishColor, " 0,\n          ", embellishColor, " ", euiTheme.size.base, ",\n          transparent 0\n        );;label:embellish;")
  };
};