"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMarkdownFormat = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _unified = _interopRequireDefault(require("unified"));
var _classnames = _interopRequireDefault(require("classnames"));
var _text = require("../text/text");
var _text_color = require("../text/text_color");
var _services = require("../../services");
var _markdown_format = require("./markdown_format.styles");
var _markdown_default_plugins = require("./plugins/markdown_default_plugins");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "parsingPluginList", "processingPluginList", "textSize", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiMarkdownFormat = exports.EuiMarkdownFormat = function EuiMarkdownFormat(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$parsingPluginLis = _ref.parsingPluginList,
    parsingPluginList = _ref$parsingPluginLis === void 0 ? _markdown_default_plugins.defaultParsingPlugins : _ref$parsingPluginLis,
    _ref$processingPlugin = _ref.processingPluginList,
    processingPluginList = _ref$processingPlugin === void 0 ? _markdown_default_plugins.defaultProcessingPlugins : _ref$processingPlugin,
    _ref$textSize = _ref.textSize,
    textSize = _ref$textSize === void 0 ? 'm' : _ref$textSize,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'default' : _ref$color,
    rest = _objectWithoutProperties(_ref, _excluded);
  var processor = (0, _react.useMemo)(function () {
    return (0, _unified.default)().use(parsingPluginList).use(processingPluginList);
  }, [parsingPluginList, processingPluginList]);
  var result = (0, _react.useMemo)(function () {
    try {
      var _ref2;
      var processed = processor.processSync(children);
      // `.result` is intentionally `unknown` (https://github.com/vfile/vfile/pull/53)
      // cast to something expected.
      return (_ref2 = processed.result) !== null && _ref2 !== void 0 ? _ref2 : processed.contents;
    } catch (e) {
      return children;
    }
  }, [children, processor]);
  var styles = (0, _services.useEuiMemoizedStyles)(_markdown_format.euiMarkdownFormatStyles);
  var cssStyles = [styles.euiMarkdownFormat, styles[textSize], (0, _text_color._isNamedColor)(color) ? styles.colors[color] : styles.colors.custom];
  var classes = (0, _classnames.default)('euiMarkdownFormat', className);
  return (0, _react2.jsx)(_text.EuiText, _extends({
    size: textSize,
    css: cssStyles,
    className: classes,
    color: color
  }, rest), result);
};
EuiMarkdownFormat.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  children: _propTypes.default.string.isRequired,
  /** array of unified plugins to parse content into an AST */parsingPluginList: _propTypes.default.any,
  /** array of unified plugins to convert the AST into a ReactNode */processingPluginList: _propTypes.default.any,
  /**
       * Determines the text size. Choose `relative` to control the `font-size` based on the value of a parent container.
       */
  textSize: _propTypes.default.any
};