"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkStyles = exports.euiMarkScreenReaderStyles = void 0;
var _react = require("@emotion/react");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _accessibility = require("../accessibility");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiMarkStyles = exports.euiMarkStyles = function euiMarkStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiMark: /*#__PURE__*/(0, _react.css)((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      // Override the browser's black color.
      // Can't use 'inherit' because the text to background color contrast may not be sufficient
      none: "\n          color: ".concat(euiTheme.colors.textParagraph, ";\n          background-color: ").concat(euiTheme.components.markBackground, ";\n        "),
      // `!important` is required here because some marked text links
      // (e.g. EuiSideNav) will take precedence otherwise
      preferred: "\n          color: ".concat(euiTheme.colors.emptyShade, " !important;\n          background-color: ").concat(euiTheme.colors.backgroundFilledPrimary, ";\n        ")
    }), " font-weight:", euiTheme.font.weight.bold, ";;label:euiMark;")
  };
};
var euiMarkScreenReaderStyles = exports.euiMarkScreenReaderStyles = function euiMarkScreenReaderStyles(highlightStart, highlightEnd) {
  return {
    hasScreenReaderHelpText: /*#__PURE__*/(0, _react.css)("&::before,&::after{", (0, _accessibility.euiScreenReaderOnly)(), ";}&::before{content:' [", highlightStart, "] ';}&::after{content:' [", highlightEnd, "] ';};label:hasScreenReaderHelpText;")
  };
};