"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiKeyPadMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _form_label = require("../form/form_label/form_label");
var _key_pad_menu = require("./key_pad_menu.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "checkable"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiKeyPadMenu = exports.EuiKeyPadMenu = function EuiKeyPadMenu(_ref) {
  var _checkable$legendProp;
  var children = _ref.children,
    className = _ref.className,
    checkable = _ref.checkable,
    rest = _objectWithoutProperties(_ref, _excluded);
  var hasCheckableConfig = _typeof(checkable) === 'object';
  var classes = (0, _classnames.default)('euiKeyPadMenu', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_key_pad_menu.euiKeyPadMenuStyles);
  var cssStyles = [styles.euiKeyPadMenu];
  var legendCssStyles = [styles.euiKeyPadMenu__legend, hasCheckableConfig && (checkable === null || checkable === void 0 || (_checkable$legendProp = checkable.legendProps) === null || _checkable$legendProp === void 0 ? void 0 : _checkable$legendProp.css)];
  var legend = hasCheckableConfig && checkable.legend ? (0, _react2.jsx)(_form_label.EuiFormLabel, _extends({}, checkable.legendProps, {
    css: legendCssStyles,
    type: "legend"
  }), checkable.legend) : undefined;
  return checkable ? (0, _react2.jsx)("fieldset", _extends({
    css: cssStyles,
    className: classes,
    "aria-label": hasCheckableConfig ? checkable.ariaLegend : undefined
  }, rest), legend, children) : (0, _react2.jsx)("ul", _extends({
    css: cssStyles,
    className: classes
  }, rest), _react.default.Children.map(children, function (child) {
    return (0, _react2.jsx)("li", null, child);
  }));
};
EuiKeyPadMenu.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Renders the the group as a `fieldset`.
       * Set to `true` to customize the labelling, or pass an {@link _EuiKeyPadMenuCheckableProps} object to add a `legend` or `ariaLegend`
       */
  checkable: _propTypes.default.oneOfType([_propTypes.default.shape({
    /**
         * Rendered within a `legend` to label the `fieldset`.
         * To create a visually hidden legend, use `ariaLegend`
         */
    legend: _propTypes.default.node,
    /**
         * Pass through props to a `EuiFormLabel` component, except for `type`
         */
    legendProps: _propTypes.default.any,
    /**
         * Custom aria-attribute for creating a *visually hidden* legend.
         * To create a visible legend, use `legend`
         */
    ariaLegend: _propTypes.default.string
  }).isRequired, _propTypes.default.oneOf([true])])
};