"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHighlight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _mark = require("../mark");
var _highlight_all = require("./_highlight_all");
var _highlight_first = require("./_highlight_first");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "search", "strict", "highlightAll", "hasScreenReaderHelpText"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiHighlight = exports.EuiHighlight = function EuiHighlight(_ref) {
  var children = _ref.children,
    className = _ref.className,
    search = _ref.search,
    _ref$strict = _ref.strict,
    strict = _ref$strict === void 0 ? false : _ref$strict,
    _ref$highlightAll = _ref.highlightAll,
    highlightAll = _ref$highlightAll === void 0 ? false : _ref$highlightAll,
    _ref$hasScreenReaderH = _ref.hasScreenReaderHelpText,
    hasScreenReaderHelpText = _ref$hasScreenReaderH === void 0 ? true : _ref$hasScreenReaderH,
    rest = _objectWithoutProperties(_ref, _excluded);
  var hasSearch = search && search.length > 0;
  var HighlightComponent = (0, _react.useMemo)(function () {
    var Component = function Component(_ref2) {
      var children = _ref2.children;
      return (0, _react2.jsx)(_mark.EuiMark, {
        hasScreenReaderHelpText: hasScreenReaderHelpText
      }, children);
    };
    Component.propTypes = {
      children: _propTypes.default.string.isRequired
    };
    Component.displayName = '_HighlightComponent';
    return Component;
  }, [hasScreenReaderHelpText]);
  return (0, _react2.jsx)("span", _extends({
    className: className
  }, rest), children && hasSearch ? highlightAll ? (0, _react2.jsx)(_highlight_all.HighlightAll, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : (0, _react2.jsx)(_highlight_first.HighlightFirst, {
    searchValue: search,
    searchSubject: children,
    isStrict: strict,
    highlightComponent: HighlightComponent
  }) : children);
};
EuiHighlight.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * string to highlight as this component's content
       */
  children: _propTypes.default.string.isRequired,
  /**
       * What to search for.
       *
       * Allows passing an array of strings (searching by multiple separate
       * words or phrases) **only** if `highlightAll` is also set to `true`.
       */
  search: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired]).isRequired,
  /**
       * Should the search be strict or not
       */
  strict: _propTypes.default.bool,
  /**
       * Should highlight all matches
       */
  highlightAll: _propTypes.default.bool
};