"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSwitchStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _high_contrast = require("../../../global_styling/functions/high_contrast");
var _form = require("../form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiSwitchVars = function euiSwitchVars(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var formVars = (0, _form.euiFormCustomControlVariables)(euiThemeContext);
  var colors = {
    on: euiTheme.components.switchBackgroundOn,
    off: highContrastMode ? euiTheme.colors.darkShade : euiTheme.components.switchBackgroundOff,
    disabled: formVars.colors.disabled,
    thumb: formVars.colors.selectedIcon,
    thumbDisabled: euiTheme.components.switchThumbBackgroundDisabled,
    thumbBorder: highContrastMode ? euiTheme.border.color : euiTheme.components.switchThumbBorderOff,
    thumbBorderOn: highContrastMode ? euiTheme.border.color : euiTheme.components.switchThumbBorderOn,
    thumbBorderDisabled: highContrastMode ? euiTheme.colors.borderBaseDisabled : formVars.colors.disabledBorder,
    iconDisabled: euiTheme.components.switchIconDisabled
  };
  var sizes = {
    uncompressed: {
      height: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x * 1.25;
      }),
      width: (0, _global_styling.mathWithUnits)([euiTheme.size.xxl, euiTheme.size.xs], function (x, y) {
        return x + y;
      }),
      thumbScales: {
        default: 1,
        hover: 1.05,
        active: 0.9
      }
    },
    compressed: {
      height: euiTheme.size.base,
      width: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
        return x * 1.75;
      }),
      thumbScales: {
        default: 0.9,
        hover: 0.95,
        active: 0.8
      }
    },
    get mini() {
      return {
        height: (0, _global_styling.mathWithUnits)(this.uncompressed.height, function (x) {
          return x / 2;
        }),
        width: (0, _global_styling.mathWithUnits)(this.uncompressed.width, function (x) {
          return x / 2;
        }),
        thumbScales: {
          default: 0.8,
          hover: undefined,
          active: undefined
        }
      };
    }
  };
  var animation = {
    speed: euiTheme.animation.normal,
    easing: euiTheme.animation.bounce
  };
  var label = {
    disabled: formVars.colors.disabledLabel,
    gap: formVars.sizes.labelGap
  };
  return {
    sizes: sizes,
    colors: colors,
    animation: animation,
    label: label
  };
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "b86pnw-disabled",
  styles: "cursor:not-allowed;label:disabled;"
} : {
  name: "b86pnw-disabled",
  styles: "cursor:not-allowed;label:disabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "eg68pp-euiSwitch",
  styles: "position:relative;display:inline-flex;align-items:flex-start;/* Required for inline-flex CSS to not render an extra 2-3px of strut height\n       * @see https://stackoverflow.com/a/27536461/4294462 */vertical-align:middle;label:euiSwitch;"
} : {
  name: "eg68pp-euiSwitch",
  styles: "position:relative;display:inline-flex;align-items:flex-start;/* Required for inline-flex CSS to not render an extra 2-3px of strut height\n       * @see https://stackoverflow.com/a/27536461/4294462 */vertical-align:middle;label:euiSwitch;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSwitchStyles = exports.euiSwitchStyles = function euiSwitchStyles(euiThemeContext) {
  var switchVars = euiSwitchVars(euiThemeContext);
  return {
    euiSwitch: _ref2,
    // Skip css`` to avoid generating an extra Emotion className
    enabled: "\n      cursor: pointer;\n    ",
    disabled: _ref,
    button: buttonStyles(euiThemeContext, switchVars),
    // The track body must be separate from the button wrapper, because the
    // icons have their overflow hidden outside the button, but the thumb doesn't
    body: bodyStyles(euiThemeContext, switchVars),
    icons: iconStyles(euiThemeContext, switchVars),
    thumb: thumbStyles(euiThemeContext, switchVars),
    label: labelStyles(euiThemeContext, switchVars)
  };
};
var buttonStyles = function buttonStyles(euiThemeContext, switchVars) {
  var _switchVars$sizes = switchVars.sizes,
    uncompressed = _switchVars$sizes.uncompressed,
    compressed = _switchVars$sizes.compressed,
    mini = _switchVars$sizes.mini;
  return {
    euiSwitch__button: /*#__PURE__*/(0, _react.css)("flex-shrink:0;line-height:0;position:relative;cursor:inherit;", (0, _global_styling.euiFocusRing)(euiThemeContext, 'outset'), ";;label:euiSwitch__button;"),
    // Skip css`` to avoid generating an Emotion className
    uncompressed: "\n      ".concat((0, _global_styling.logicalSizeCSS)(uncompressed.width, uncompressed.height), "\n      border-radius: ").concat(uncompressed.height, ";\n    "),
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(compressed.width, compressed.height), " border-radius:", compressed.height, ";;label:compressed;"),
    mini: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)(mini.width, mini.height), " border-radius:", mini.height, ";;label:mini;")
  };
};
var bodyStyles = function bodyStyles(euiThemeContext, _ref3) {
  var colors = _ref3.colors;
  var euiTheme = euiThemeContext.euiTheme;

  // This is probably very extra, but the visual weight of the default
  // disabled custom control feels different in light mode depending
  // on the size of the switch, so I'm tinting it based on that.
  // Gotta justify my stupidly expensive art degree!
  var _disabledStyles = function _disabledStyles(color) {
    return /*#__PURE__*/(0, _react.css)("label:disabled;background-color:", color, ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      preferred: "border: ".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.borderBaseDisabled, ";")
    }), ";");
  };
  return {
    euiSwitch__body: /*#__PURE__*/(0, _react.css)("position:absolute;inset:0;overflow:hidden;border-radius:inherit;pointer-events:none;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      forced: "border: ".concat(euiTheme.border.thin, ";")
    }), ";;label:euiSwitch__body;"),
    on: /*#__PURE__*/(0, _react.css)((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          background-color: ".concat(colors.on, ";\n        "),
      forced: "\n          background-color: ".concat(euiTheme.border.color, ";\n          ").concat((0, _high_contrast.preventForcedColors)(euiThemeContext), "\n        ")
    }), ";label:on;"),
    off: /*#__PURE__*/(0, _react.css)("background-color:", colors.off, ";;label:off;"),
    disabled: {
      uncompressed: _disabledStyles(euiTheme.components.switchUncompressedBackgroundDisabled),
      compressed: _disabledStyles(euiTheme.components.switchCompressedBackgroundDisabled),
      mini: _disabledStyles(euiTheme.components.switchMiniBackgroundDisabled)
    }
  };
};
var iconStyles = function iconStyles(_ref4, _ref5) {
  var euiTheme = _ref4.euiTheme;
  var colors = _ref5.colors,
    animation = _ref5.animation;
  return {
    euiSwitch__icons: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('vertical', 0), " ", (0, _global_styling.logicalCSS)('left', '-50%'), " ", (0, _global_styling.logicalCSS)('width', '200%'), " display:flex;justify-content:space-around;align-items:center;", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), " ", _global_styling.euiCanAnimate, "{transition-property:inset-inline-start;transition-duration:", animation.speed, ";transition-timing-function:", animation.easing, ";};label:euiSwitch__icons;"),
    on: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', '-25%'), ";;label:on;"),
    off: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', '-75%'), ";;label:off;"),
    enabled: /*#__PURE__*/(0, _react.css)("color:", colors.thumb, ";;label:enabled;"),
    disabled: /*#__PURE__*/(0, _react.css)("color:", colors.iconDisabled, ";;label:disabled;")
  };
};
var thumbStyles = function thumbStyles(_ref6, switchVars) {
  var euiTheme = _ref6.euiTheme;
  var sizes = switchVars.sizes,
    colors = switchVars.colors,
    animation = switchVars.animation;
  var uncompressed = sizes.uncompressed,
    compressed = sizes.compressed,
    mini = sizes.mini;
  var _calculateScale = function _calculateScale(size, hoverActiveStates) {
    var baseScale = "transform: scale(".concat(sizes[size].thumbScales.default, ");");
    var states = hoverActiveStates ? "\n      .euiSwitch:hover & {\n        transform: scale(".concat(sizes[size].thumbScales.hover, ");\n      }\n      .euiSwitch:active & {\n        transform: scale(").concat(sizes[size].thumbScales.active, ");\n      }") : '';
    return "".concat(baseScale).concat(states);
  };
  return {
    euiSwitch__thumb: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('vertical', 0), " aspect-ratio:1;", (0, _global_styling.logicalCSS)('width', 'fit-content'), " ", (0, _global_styling.logicalCSS)('height', '100%'), " border-radius:50%;pointer-events:none;", _global_styling.euiCanAnimate, "{transition-property:inset-inline-start,transform,background-color,border-color;transition-duration:", animation.speed, ";transition-timing-function:", animation.easing, ";};label:euiSwitch__thumb;"),
    off: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('left', 0), ";;label:off;"),
    get on() {
      var baseStyles = "\n        border: ".concat(euiTheme.border.width.thin, " solid ").concat(colors.thumbBorderOn, ";\n      ");

      // right: 0 works but doesn't transition/animate, so we need to
      // manually calculate the left position per switch size
      var _calculateLeft = function _calculateLeft(bodyWidth, thumbWidth) {
        var leftPosition = (0, _global_styling.mathWithUnits)([bodyWidth, thumbWidth], function (x, y) {
          return x - y;
        });
        return /*#__PURE__*/(0, _react.css)("label:on;", (0, _global_styling.logicalCSS)('left', leftPosition), " ", baseStyles, ";");
      };
      return {
        uncompressed: _calculateLeft(uncompressed.width, uncompressed.height),
        compressed: _calculateLeft(compressed.width, compressed.height),
        mini: _calculateLeft(mini.width, mini.height)
      };
    },
    enabled: {
      enabled: "\n        background-color: ".concat(colors.thumb, ";\n        border: ").concat(euiTheme.border.width.thin, " solid ").concat(colors.thumbBorder, ";\n      "),
      uncompressed: _calculateScale('uncompressed', true),
      compressed: _calculateScale('compressed', true),
      mini: _calculateScale('mini', false)
    },
    disabled: {
      disabled: /*#__PURE__*/(0, _react.css)("background-color:", colors.thumbDisabled, ";border:", euiTheme.border.width.thin, " solid ", colors.thumbBorderDisabled, ";;label:disabled;"),
      uncompressed: _calculateScale('uncompressed', false),
      compressed: _calculateScale('compressed', false),
      mini: _calculateScale('mini', false)
    }
  };
};
var labelStyles = function labelStyles(euiThemeContext, _ref7) {
  var sizes = _ref7.sizes,
    label = _ref7.label;
  var uncompressed = sizes.uncompressed,
    compressed = sizes.compressed,
    mini = sizes.mini;
  return {
    euiSwitch__label: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-left', label.gap), ";;label:euiSwitch__label;"),
    // Skip css`` to avoid generating an Emotion className
    uncompressed: "\n      font-size: ".concat((0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";\n      line-height: ").concat(uncompressed.height, ";\n    "),
    compressed: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";line-height:", compressed.height, ";;label:compressed;"),
    mini: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";line-height:", mini.height, ";;label:mini;"),
    disabled: /*#__PURE__*/(0, _react.css)("color:", label.disabled, ";;label:disabled;")
  };
};