"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHue = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _accessibility = require("../accessibility");
var _i18n = require("../i18n");
var _hue = require("./hue.styles");
var _tool_tip = require("../tool_tip");
var _react2 = require("@emotion/react");
var _excluded = ["className", "hex", "hue", "id", "onChange"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var HUE_RANGE = 359;
var EuiHue = exports.EuiHue = function EuiHue(_ref) {
  var className = _ref.className,
    hex = _ref.hex,
    _ref$hue = _ref.hue,
    hue = _ref$hue === void 0 ? 1 : _ref$hue,
    id = _ref.id,
    onChange = _ref.onChange,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiHue', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_hue.euiHueStyles);
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiHue.ariaValueText', 'euiHue.ariaRoleDescription'], ['Hue', 'Hue slider']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    ariaValueText = _useEuiI18n2[0],
    ariaRoleDescription = _useEuiI18n2[1];
  var handleChange = function handleChange(e) {
    onChange(Number(e.target.value));
  };
  var hueValue = typeof hue === 'string' ? parseInt(hue) : hue;
  // align the tooltip contextually closer to the thumb
  var tooltipPosition = hueValue < Math.floor(HUE_RANGE / 2) ? 'left' : 'right';
  return (0, _react2.jsx)("div", {
    css: styles.euiHue,
    className: classes
  }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("label", {
    htmlFor: "".concat(id, "-hue")
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiHue.label",
    default: "Select the HSV color mode 'hue' value"
  }))), (0, _react2.jsx)(_tool_tip.EuiToolTip, {
    content: hex,
    anchorProps: {
      css: styles.euiHue__tooltip
    },
    disableScreenReaderOutput: true,
    position: tooltipPosition
  }, (0, _react2.jsx)("input", _extends({
    id: "".concat(id, "-hue"),
    min: 0,
    max: HUE_RANGE,
    step: 1,
    type: "range",
    css: styles.euiHue__range,
    className: "euiHue__range",
    value: hue,
    onChange: handleChange,
    "aria-roledescription": ariaRoleDescription,
    "aria-valuetext": "".concat(ariaValueText, " ").concat(hue, "\xB0")
  }, rest))));
};
EuiHue.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  hex: _propTypes.default.string,
  hue: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]),
  onChange: _propTypes.default.func.isRequired
};