"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.shippersMock = void 0;
var rxjs_1 = require("rxjs");
function createShipper() {
    return new MockedShipper();
}
var MockedShipper = /** @class */ (function () {
    function MockedShipper() {
        this.optIn = jest.fn();
        this.reportEvents = jest.fn();
        this.extendContext = jest.fn();
        this.telemetryCounter$ = new rxjs_1.Subject();
        this.flush = jest.fn();
        this.shutdown = jest.fn();
    }
    MockedShipper.shipperName = 'mocked-shipper';
    return MockedShipper;
}());
exports.shippersMock = {
    createShipper: createShipper,
    MockedShipper: MockedShipper,
};
