"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getInitialTooltipState = exports.getInitialPointerState = void 0;
exports.getSpecsFromStore = getSpecsFromStore;
exports.getSpecFromStore = getSpecFromStore;
exports.isClicking = isClicking;
const keys_1 = require("../utils/keys");
function getSpecsFromStore(specs, chartType, specType) {
    return Object.values(specs).filter((spec) => spec.chartType === chartType && spec.specType === specType);
}
function getSpecFromStore(specs, chartType, specType, required) {
    const spec = Object.values(specs).find((spec) => spec.chartType === chartType && spec.specType === specType);
    if (!spec && required)
        throw new Error(`Unable to find spec [${chartType} = ${specType}]`);
    return spec ?? null;
}
function isClicking(prevClick, lastClick) {
    return lastClick && (!prevClick || prevClick.time !== lastClick.time);
}
const getInitialPointerState = () => ({
    dragging: false,
    current: { position: { x: -1, y: -1 }, time: 0 },
    pinned: null,
    down: null,
    up: null,
    lastDrag: null,
    lastClick: null,
    keyPressed: keys_1.noModifierKeysPressed,
});
exports.getInitialPointerState = getInitialPointerState;
const getInitialTooltipState = () => ({
    pinned: false,
    selected: [],
});
exports.getInitialTooltipState = getInitialTooltipState;
//# sourceMappingURL=utils.js.map