"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAxisTickLabelFormatter = void 0;
const get_api_scale_configs_1 = require("./get_api_scale_configs");
const get_specs_1 = require("./get_specs");
const create_selector_1 = require("../../../../state/create_selector");
const get_settings_spec_1 = require("../../../../state/selectors/get_settings_spec");
const axis_utils_1 = require("../../utils/axis_utils");
const group_data_series_1 = require("../../utils/group_data_series");
exports.getAxisTickLabelFormatter = (0, create_selector_1.createCustomCachedSelector)([get_specs_1.getSeriesSpecsSelector, get_specs_1.getAxisSpecsSelector, get_settings_spec_1.getSettingsSpecSelector, get_api_scale_configs_1.getScaleConfigsFromSpecsSelector], (seriesSpecs, axesSpecs, { rotation }, scaleConfigs) => {
    const seriesByGroupId = (0, group_data_series_1.groupBy)(seriesSpecs, ['groupId'], false);
    const axesByGroupId = (0, group_data_series_1.groupBy)(axesSpecs, ['groupId'], false);
    const groupIds = [...new Set([...Object.keys(seriesByGroupId), ...Object.keys(axesByGroupId)])];
    const { timeZone } = scaleConfigs.x;
    return groupIds.reduce((acc, groupId) => {
        const ySpecDataFormatter = (seriesByGroupId[groupId] ?? []).find(({ tickFormat }) => tickFormat)?.tickFormat;
        const axes = groupAxesByCartesianCoords(axesByGroupId[groupId] ?? [], rotation);
        axes.x.forEach((spec) => {
            acc.x.set(spec.id, (v) => (spec?.labelFormat ?? spec?.tickFormat ?? axis_utils_1.defaultTickFormatter)(v, { timeZone }));
        });
        axes.y.forEach((spec) => {
            acc.y.set(spec.id, (v) => (spec.labelFormat ?? spec.tickFormat ?? ySpecDataFormatter ?? axis_utils_1.defaultTickFormatter)(v, {}));
        });
        return acc;
    }, { x: new Map(), y: new Map() });
});
function groupAxesByCartesianCoords(sameGroupAxes, chartRotation = 0) {
    return sameGroupAxes.reduce((acc, spec) => {
        acc[(0, axis_utils_1.isXDomain)(spec.position, chartRotation) ? 'x' : 'y'].push(spec);
        return acc;
    }, { x: [], y: [] });
}
//# sourceMappingURL=axis_tick_formatter.js.map