"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HistogramBarSeries = void 0;
const __1 = require("../..");
const constants_1 = require("../../../scales/constants");
const spec_type_1 = require("../../../specs/spec_type");
const spec_factory_1 = require("../../../state/spec_factory");
const common_1 = require("../../../utils/common");
const specs_1 = require("../utils/specs");
const buildProps = (0, spec_factory_1.buildSFProps)()({
    chartType: __1.ChartType.XYAxis,
    specType: spec_type_1.SpecType.Series,
    seriesType: specs_1.SeriesType.Bar,
}, {
    groupId: specs_1.DEFAULT_GLOBAL_ID,
    xScaleType: constants_1.ScaleType.Linear,
    yScaleType: constants_1.ScaleType.Linear,
    hideInLegend: false,
    enableHistogramMode: true,
});
const HistogramBarSeries = function (props) {
    const { defaults, overrides } = buildProps;
    (0, spec_factory_1.useSpecFactory)({ ...defaults, ...(0, common_1.stripUndefined)(props), ...overrides });
    return null;
};
exports.HistogramBarSeries = HistogramBarSeries;
//# sourceMappingURL=histogram_bar_series.js.map