"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PADDING = void 0;
exports.getFitValueFontSize = getFitValueFontSize;
exports.getMetricTextPartDimensions = getMetricTextPartDimensions;
exports.getFittedFontSizes = getFittedFontSizes;
exports.getFixedFontSizes = getFixedFontSizes;
exports.getSnappedFontSizes = getSnappedFontSizes;
exports.elementVisibility = elementVisibility;
const text_processing_1 = require("./text_processing");
const default_theme_attributes_1 = require("../../../../common/default_theme_attributes");
const canvas_text_bbox_calculator_1 = require("../../../../utils/bbox/canvas_text_bbox_calculator");
const common_1 = require("../../../../utils/common");
const wrap_1 = require("../../../../utils/text/wrap");
const specs_1 = require("../../specs");
exports.PADDING = 8;
const PROGRESS_BAR_WIDTH = 10;
const PROGRESS_BAR_TARGET_WIDTH = 4;
const LINE_HEIGHT = 1.2;
const HEIGHT_BP = [
    [100, 200, 'xs'],
    [200, 300, 's'],
    [300, 400, 'm'],
    [400, 500, 'l'],
    [500, 600, 'xl'],
    [600, Infinity, 'xxl'],
];
const ICON_SIZE = { xxxs: 16, xxs: 16, xs: 16, s: 16, m: 24, l: 24, xl: 32, xxl: 42 };
const TITLE_FONT_SIZE = { xxxs: 16, xxs: 16, xs: 16, s: 16, m: 24, l: 24, xl: 32, xxl: 42 };
const SUBTITLE_FONT_SIZE = {
    xxxs: 14,
    xxs: 14,
    xs: 14,
    s: 14,
    m: 16,
    l: 20,
    xl: 26,
    xxl: 36,
};
const EXTRA_FONT_SIZE = { xxxs: 14, xxs: 14, xs: 14, s: 14, m: 16, l: 20, xl: 26, xxl: 36 };
const VALUE_FONT_SIZE = {
    xxxs: 16,
    xxs: 26,
    xs: 36,
    s: 42,
    m: 56,
    l: 72,
    xl: 104,
    xxl: 170,
};
const VALUE_FONT_SIZE_VALUES = [
    VALUE_FONT_SIZE.xl,
    VALUE_FONT_SIZE.l,
    VALUE_FONT_SIZE.m,
    VALUE_FONT_SIZE.s,
    VALUE_FONT_SIZE.xs,
    VALUE_FONT_SIZE.xxs,
    VALUE_FONT_SIZE.xxxs,
];
const VALUE_PART_FONT_RATIO = 1.3;
const TITLE_FONT = {
    fontStyle: 'normal',
    fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
    fontVariant: 'normal',
    fontWeight: 'bold',
    textColor: 'black',
};
const VALUE_FONT = TITLE_FONT;
const SUBTITLE_FONT = {
    ...TITLE_FONT,
    fontWeight: 'normal',
};
function getFitValueFontSize(valueFontSize, width, gapHeight, textParts, minValueFontSize, hasIcon) {
    const maxWidth = (width - 2 * exports.PADDING) * 0.98;
    const widthConstrainedSize = (0, canvas_text_bbox_calculator_1.withTextMeasure)((textMeasure) => {
        const iconMultiplier = hasIcon ? 1 : 0;
        const textWidth = textParts.reduce((sum, { text, emphasis }) => {
            const fontSize = emphasis === 'small' ? Math.floor(valueFontSize / VALUE_PART_FONT_RATIO) : valueFontSize;
            return sum + textMeasure(text, VALUE_FONT, fontSize).width;
        }, 0);
        const ratio = textWidth / valueFontSize;
        return (maxWidth - iconMultiplier * exports.PADDING) / (ratio + iconMultiplier / VALUE_PART_FONT_RATIO);
    });
    const heightConstrainedSize = valueFontSize + gapHeight;
    return Math.floor(Math.max(Math.min(heightConstrainedSize, widthConstrainedSize), minValueFontSize));
}
function getMetricTextPartDimensions(datum, panel, style, locale) {
    const heightBasedSizes = getHeightBasedFontSizes(HEIGHT_BP, panel.height, style);
    const hasProgressBar = (0, specs_1.isMetricWProgress)(datum);
    const hasTarget = !(0, common_1.isNil)(datum?.target);
    const progressBarDirection = (0, specs_1.isMetricWProgress)(datum) ? datum.progressBarDirection : undefined;
    return {
        heightBasedSizes,
        hasProgressBar,
        progressBarDirection,
        progressBarWidth: hasProgressBar && progressBarDirection === common_1.LayoutDirection.Vertical
            ? PROGRESS_BAR_WIDTH + (hasTarget ? PROGRESS_BAR_TARGET_WIDTH : 0)
            : 0,
        visibility: elementVisibility(datum, panel, heightBasedSizes, locale, style.valueFontSize === 'fit'),
        textParts: (0, text_processing_1.getTextParts)(datum, style),
    };
}
function getHeightBasedFontSizes(ranges, value, style) {
    const range = ranges.find(([min, max]) => min <= value && value < max);
    const size = range ? range[2] : ranges[0]?.[2] ?? 's';
    const valueFontSize = typeof style.valueFontSize === 'number' ? style.valueFontSize : VALUE_FONT_SIZE[size];
    const valuePartFontSize = Math.floor(valueFontSize / VALUE_PART_FONT_RATIO);
    return {
        iconSize: ICON_SIZE[size],
        titleFontSize: TITLE_FONT_SIZE[size],
        subtitleFontSize: SUBTITLE_FONT_SIZE[size],
        extraFontSize: EXTRA_FONT_SIZE[size],
        valueFontSize,
        valuePartFontSize,
    };
}
function getFittedFontSizes(fittedValueFontSize) {
    return {
        valueFontSize: fittedValueFontSize,
        valuePartFontSize: Math.floor(fittedValueFontSize / VALUE_PART_FONT_RATIO),
    };
}
function getFixedFontSizes(fixedFontSize) {
    return {
        valueFontSize: fixedFontSize,
        valuePartFontSize: Math.floor(fixedFontSize / VALUE_PART_FONT_RATIO),
    };
}
function getSnappedFontSizes(fittedValueFontSize, panelHeight, style) {
    const sizes = getHeightBasedFontSizes(HEIGHT_BP, panelHeight, style);
    const minFontSize = Math.min(fittedValueFontSize, sizes.valueFontSize);
    const fontSize = (0, common_1.clamp)(VALUE_FONT_SIZE_VALUES.find((value) => value <= minFontSize) ?? minFontSize, VALUE_FONT_SIZE.xxxs, VALUE_FONT_SIZE.xxl);
    return {
        valueFontSize: fontSize,
        valuePartFontSize: Math.floor(fontSize / VALUE_PART_FONT_RATIO),
    };
}
function elementVisibility(datum, panel, sizes, locale, fit) {
    const maxTitlesWidth = 0.95 * panel.width - (datum.icon ? 24 : 0) - 2 * exports.PADDING;
    const titleHeight = (maxLines, textMeasure) => {
        return datum.title
            ? exports.PADDING +
                (0, wrap_1.wrapText)(datum.title, TITLE_FONT, sizes.titleFontSize, maxTitlesWidth, maxLines, textMeasure, locale).length *
                    sizes.titleFontSize *
                    LINE_HEIGHT
            : 0;
    };
    const subtitleHeight = (maxLines, textMeasure) => {
        return datum.subtitle
            ? exports.PADDING +
                (0, wrap_1.wrapText)(datum.subtitle, SUBTITLE_FONT, sizes.subtitleFontSize, maxTitlesWidth, maxLines, textMeasure, locale)
                    .length *
                    sizes.subtitleFontSize *
                    LINE_HEIGHT
            : 0;
    };
    const extraHeight = sizes.extraFontSize * LINE_HEIGHT;
    const valueHeight = sizes.valueFontSize * LINE_HEIGHT;
    const responsiveBreakPoints = [
        { titleMaxLines: 3, subtitleMaxLines: 2, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 3, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 2, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 1, title: !!datum.title, subtitle: !!datum.subtitle, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: !!datum.extra },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: false },
        { titleMaxLines: 1, subtitleMaxLines: 0, title: !!datum.title, subtitle: false, extra: false },
    ];
    const getCombinedHeight = ({ titleMaxLines, subtitleMaxLines, title, subtitle, extra }, measure) => (title && titleMaxLines > 0 ? titleHeight(titleMaxLines, measure) : 0) +
        (subtitle && subtitleMaxLines > 0 ? subtitleHeight(subtitleMaxLines, measure) : 0) +
        (extra ? extraHeight : 0) +
        valueHeight +
        exports.PADDING;
    const isVisible = (ev, measure) => getCombinedHeight(ev, measure) < panel.height;
    return (0, canvas_text_bbox_calculator_1.withTextMeasure)((textMeasure) => {
        const visibilityBreakpoint = fit
            ? responsiveBreakPoints.at(0)
            : responsiveBreakPoints.find((breakpoint) => isVisible(breakpoint, textMeasure)) ?? responsiveBreakPoints.at(-1);
        return {
            ...visibilityBreakpoint,
            gapHeight: Math.max(0, panel.height - getCombinedHeight(visibilityBreakpoint, textMeasure)),
            titleLines: (0, wrap_1.wrapText)(datum.title ?? '', TITLE_FONT, sizes.titleFontSize, maxTitlesWidth, visibilityBreakpoint.titleMaxLines, textMeasure, locale),
            subtitleLines: (0, wrap_1.wrapText)(datum.subtitle ?? '', SUBTITLE_FONT, sizes.subtitleFontSize, maxTitlesWidth, visibilityBreakpoint.subtitleMaxLines, textMeasure, locale),
        };
    });
}
//# sourceMappingURL=text_measurements.js.map