"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.chartTypeRenderer = void 0;
const chart_renderer_1 = require("./bullet_graph/chart_renderer");
const flame_chart_1 = require("./flame_chart/flame_chart");
const chart_renderer_2 = require("./goal_chart/state/chart_renderer");
const chart_renderer_3 = require("./heatmap/state/chart_renderer");
const index_1 = require("./index");
const chart_renderer_4 = require("./metric/state/chart_renderer");
const layered_partition_chart_1 = require("./partition_chart/renderer/dom/layered_partition_chart");
const timeslip_chart_1 = require("./timeslip/timeslip_chart");
const chart_renderer_5 = require("./wordcloud/state/chart_renderer");
const chart_renderer_6 = require("./xy_chart/state/chart_renderer");
exports.chartTypeRenderer = {
    [index_1.ChartType.Goal]: () => chart_renderer_2.chartRenderer,
    [index_1.ChartType.Partition]: () => layered_partition_chart_1.chartRenderer,
    [index_1.ChartType.Flame]: () => flame_chart_1.FlameWithTooltip,
    [index_1.ChartType.Timeslip]: () => timeslip_chart_1.chartRenderer,
    [index_1.ChartType.XYAxis]: () => chart_renderer_6.chartRenderer,
    [index_1.ChartType.Heatmap]: () => chart_renderer_3.chartRenderer,
    [index_1.ChartType.Wordcloud]: () => chart_renderer_5.chartRenderer,
    [index_1.ChartType.Metric]: () => chart_renderer_4.chartRenderer,
    [index_1.ChartType.Bullet]: () => chart_renderer_1.chartRenderer,
    [index_1.ChartType.Global]: () => null,
};
//# sourceMappingURL=chart_type_renderers.js.map