"use strict";

exports.__esModule = true;
exports.patchAll = patchAll;
exports.patchEventHandler = void 0;

var _xhrPatch = require("./xhr-patch");

var _fetchPatch = require("./fetch-patch");

var _historyPatch = require("./history-patch");

var _eventHandler = _interopRequireDefault(require("../event-handler"));

var _constants = require("../constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var patchEventHandler = new _eventHandler.default();
exports.patchEventHandler = patchEventHandler;
var alreadyPatched = false;

function patchAll() {
  if (!alreadyPatched) {
    alreadyPatched = true;
    (0, _xhrPatch.patchXMLHttpRequest)(function (event, task) {
      patchEventHandler.send(_constants.XMLHTTPREQUEST, [event, task]);
    });
    (0, _fetchPatch.patchFetch)(function (event, task) {
      patchEventHandler.send(_constants.FETCH, [event, task]);
    });
    (0, _historyPatch.patchHistory)(function (event, task) {
      patchEventHandler.send(_constants.HISTORY, [event, task]);
    });
  }

  return patchEventHandler;
}