"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchBrowserJourney = fetchBrowserJourney;
exports.fetchJourneysFailedSteps = fetchJourneysFailedSteps;
exports.fetchLastSuccessfulCheck = fetchLastSuccessfulCheck;
exports.fetchScreenshotBlockSet = fetchScreenshotBlockSet;
exports.getJourneyScreenshot = getJourneyScreenshot;
var _api_service = require("../../../../utils/api_service");
var _runtime_types = require("../../../../../common/runtime_types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchScreenshotBlockSet(params) {
  return _api_service.apiService.post(_constants.SYNTHETICS_API_URLS.JOURNEY_SCREENSHOT_BLOCKS, {
    hashes: params
  });
}
async function fetchBrowserJourney(params) {
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.JOURNEY.replace('{checkGroup}', params.checkGroup), undefined, _runtime_types.SyntheticsJourneyApiResponseType);
}
async function fetchJourneysFailedSteps({
  checkGroups
}) {
  return _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.JOURNEY_FAILED_STEPS, {
    checkGroups
  }, _runtime_types.FailedStepsApiResponseType);
}
async function fetchLastSuccessfulCheck({
  monitorId,
  timestamp,
  stepIndex,
  location
}) {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.SYNTHETICS_SUCCESSFUL_CHECK, {
    monitorId,
    timestamp,
    stepIndex,
    location
  }, _runtime_types.PingType);
}
const DEFAULT_SHOULD_BACKOFF = true;
const DEFAULT_MAX_RETRY = 8;
const DEFAULT_INITIAL_BACKOFF = 100;
async function getJourneyScreenshot(imgSrc, options) {
  var _options$shouldBackof, _options$maxRetry, _options$initialBacko;
  const shouldBackoff = (_options$shouldBackof = options === null || options === void 0 ? void 0 : options.shouldBackoff) !== null && _options$shouldBackof !== void 0 ? _options$shouldBackof : DEFAULT_SHOULD_BACKOFF;
  const maxRetry = (_options$maxRetry = options === null || options === void 0 ? void 0 : options.maxRetry) !== null && _options$maxRetry !== void 0 ? _options$maxRetry : DEFAULT_MAX_RETRY;
  const initialBackoff = (_options$initialBacko = options === null || options === void 0 ? void 0 : options.initialBackoff) !== null && _options$initialBacko !== void 0 ? _options$initialBacko : DEFAULT_INITIAL_BACKOFF;
  try {
    var _response2, _response$headers$get;
    let retryCount = 0;
    let response = null;
    let backoff = initialBackoff;
    while (((_response = response) === null || _response === void 0 ? void 0 : _response.status) !== 200) {
      var _response;
      const imgRequest = new Request(imgSrc);
      imgRequest.headers.set('x-elastic-internal-origin', 'Kibana');
      if (retryCount > maxRetry) break;
      response = await fetch(imgRequest);
      if (!shouldBackoff || response.status !== 404) break;
      await new Promise(r => setTimeout(r, backoff *= 2));
      retryCount++;
    }
    if (((_response2 = response) === null || _response2 === void 0 ? void 0 : _response2.status) !== 200) {
      return null;
    }
    const contentType = response.headers.get('content-type');
    const stepName = response.headers.get('caption-name');
    const maxSteps = Number((_response$headers$get = response.headers.get('max-steps')) !== null && _response$headers$get !== void 0 ? _response$headers$get : 0);
    if ((contentType === null || contentType === void 0 ? void 0 : contentType.indexOf('application/json')) !== -1) {
      return {
        stepName,
        maxSteps,
        ref: await response.json()
      };
    } else {
      return {
        stepName,
        maxSteps,
        src: URL.createObjectURL(await response.blob())
      };
    }
  } catch (e) {
    return null;
  }
}