"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepScreenshotDetails = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _journey_step_screenshot_container = require("../common/screenshot/journey_step_screenshot_container");
var _step_info = require("./components/step_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StepScreenshotDetails = ({
  stepIndex,
  step,
  stateId
}) => {
  var _step$monitor$check_g, _step$synthetics$payl;
  const {
    checkGroupId
  } = (0, _reactRouterDom.useParams)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: false,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      margin: '0 auto'
    },
    grow: false
  }, step ? /*#__PURE__*/_react.default.createElement(_journey_step_screenshot_container.JourneyStepScreenshotContainer, {
    key: stepIndex,
    checkGroup: (_step$monitor$check_g = step === null || step === void 0 ? void 0 : step.monitor.check_group) !== null && _step$monitor$check_g !== void 0 ? _step$monitor$check_g : checkGroupId,
    initialStepNumber: stepIndex,
    stepStatus: step === null || step === void 0 ? void 0 : (_step$synthetics$payl = step.synthetics.payload) === null || _step$synthetics$payl === void 0 ? void 0 : _step$synthetics$payl.status,
    allStepsLoaded: true,
    retryFetchOnRevisit: false,
    size: [180, 112],
    timestamp: step === null || step === void 0 ? void 0 : step['@timestamp']
  }) : null), /*#__PURE__*/_react.default.createElement(_step_info.StepMetaInfo, {
    step: step,
    stepIndex: stepIndex,
    stateId: stateId
  })));
};
exports.StepScreenshotDetails = StepScreenshotDetails;