"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PENDING_LABEL = exports.IN_PROGRESS_LABEL = void 0;
exports.TestResultHeader = TestResultHeader;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var React = _interopRequireWildcard(require("react"));
var _test_details_link = require("../common/links/test_details_link");
var _hooks = require("../../hooks");
var _contexts = require("../../contexts");
var _formatting = require("../../utils/formatting");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TestResultHeader({
  checkGroupId,
  title,
  summaryDocs,
  journeyStarted,
  isCompleted,
  configId
}) {
  var _summaryDoc$summary, _summaryDoc$summary2, _getLocationByLabel, _summaryDoc$observer, _summaryDoc$observer$;
  const {
    basePath
  } = (0, _contexts.useSyntheticsSettingsContext)();
  let duration = 0;
  if (summaryDocs && summaryDocs.length > 0) {
    summaryDocs.forEach(sDoc => {
      var _sDoc$monitor$duratio, _sDoc$monitor$duratio2;
      duration += (_sDoc$monitor$duratio = (_sDoc$monitor$duratio2 = sDoc.monitor.duration) === null || _sDoc$monitor$duratio2 === void 0 ? void 0 : _sDoc$monitor$duratio2.us) !== null && _sDoc$monitor$duratio !== void 0 ? _sDoc$monitor$duratio : 0;
    });
  }
  const {
    getLocationByLabel
  } = (0, _hooks.useLocations)();
  const summaryDoc = summaryDocs === null || summaryDocs === void 0 ? void 0 : summaryDocs[0];
  return /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, title !== null && title !== void 0 ? title : TEST_RESULT))), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    grow: true
  }, isCompleted ? /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(_eui.EuiBadge, {
    color: (summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$summary = summaryDoc.summary) === null || _summaryDoc$summary === void 0 ? void 0 : _summaryDoc$summary.down) > 0 ? 'danger' : 'success',
    css: {
      maxWidth: 'max-content'
    }
  }, (summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$summary2 = summaryDoc.summary) === null || _summaryDoc$summary2 === void 0 ? void 0 : _summaryDoc$summary2.down) > 0 ? FAILED_LABEL : COMPLETED_LABEL)), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.synthetics.monitorManagement.timeTaken', {
    defaultMessage: 'Took {timeTaken}',
    values: {
      timeTaken: (0, _formatting.formatDuration)(duration)
    }
  })))) : /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(_eui.EuiBadge, {
    style: {
      width: 100
    },
    color: journeyStarted ? 'primary' : 'warning'
  }, journeyStarted ? IN_PROGRESS_LABEL : PENDING_LABEL)), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_eui.EuiLoadingSpinner, null)))), checkGroupId && configId && isCompleted && /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsTestResultHeaderLink",
    href: (0, _test_details_link.getTestRunDetailLink)({
      basePath,
      monitorId: configId,
      checkGroup: checkGroupId,
      locationId: (_getLocationByLabel = getLocationByLabel(summaryDoc === null || summaryDoc === void 0 ? void 0 : (_summaryDoc$observer = summaryDoc.observer) === null || _summaryDoc$observer === void 0 ? void 0 : (_summaryDoc$observer$ = _summaryDoc$observer.geo) === null || _summaryDoc$observer$ === void 0 ? void 0 : _summaryDoc$observer$.name)) === null || _getLocationByLabel === void 0 ? void 0 : _getLocationByLabel.id
    })
  }, VIEW_DETAILS)));
}
const PENDING_LABEL = exports.PENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.pending', {
  defaultMessage: 'PENDING'
});
const TEST_RESULT = _i18n.i18n.translate('xpack.synthetics.monitorManagement.testResult', {
  defaultMessage: 'Test result'
});
const COMPLETED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.completed', {
  defaultMessage: 'COMPLETED'
});
const FAILED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.failed', {
  defaultMessage: 'FAILED'
});
const IN_PROGRESS_LABEL = exports.IN_PROGRESS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.inProgress', {
  defaultMessage: 'IN PROGRESS'
});
const VIEW_DETAILS = _i18n.i18n.translate('xpack.synthetics.monitorManagement.viewTestRunDetails', {
  defaultMessage: 'View test result details'
});