"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTooltipContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _waterfall_context = require("./context/waterfall_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledText = (0, _common.euiStyled)(_eui.EuiText)`
  font-weight: bold;
`;
const StyledHorizontalRule = (0, _common.euiStyled)(_eui.EuiHorizontalRule)`
  background-color: ${props => props.theme.eui.euiColorDarkShade};
`;
const WaterfallTooltipContent = ({
  text,
  url,
  index
}) => {
  const {
    renderTooltipItem,
    metadata
  } = (0, _waterfall_context.useWaterfallContext)();
  // the passed index is base 1, so we need to subtract 1 to get the correct index
  const metadataEntry = metadata === null || metadata === void 0 ? void 0 : metadata[index - 1];
  const tooltipItems = metadataEntry === null || metadataEntry === void 0 ? void 0 : metadataEntry.networkItemTooltipProps;
  const showTooltip = metadataEntry === null || metadataEntry === void 0 ? void 0 : metadataEntry.showTooltip;
  if (!tooltipItems || !showTooltip) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: 500,
      height: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(StyledText, {
    size: "xs"
  }, text), /*#__PURE__*/_react.default.createElement(StyledHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, tooltipItems.map((item, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx
  }, renderTooltipItem(item)))));
};
exports.WaterfallTooltipContent = WaterfallTooltipContent;