"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkRequestsTotal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkRequestsTotal = ({
  totalNetworkRequests,
  fetchedNetworkRequests,
  highlightedNetworkRequests
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.waterfall.networkRequests.count",
    defaultMessage: "Showing {countShown} of {total} {networkRequestsLabel}",
    values: {
      countShown: /*#__PURE__*/_react.default.createElement("strong", {
        "data-test-subj": "syntheticsWaterfallChartCountShown"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: highlightedNetworkRequests
      })),
      total: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
        value: totalNetworkRequests
      }),
      networkRequestsLabel: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.synthetics.waterfall.networkRequests.pluralizedCount', {
        defaultMessage: '{total, plural, one {network request} other {network requests}}',
        values: {
          total: totalNetworkRequests
        }
      }))
    }
  }), totalNetworkRequests > fetchedNetworkRequests && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    color: "warning",
    content: _i18n.i18n.translate('xpack.synthetics.synthetics.waterfall.requestsTotalMessage.info', {
      defaultMessage: 'Waterfall view only shows up to 1000 requests'
    })
  })));
};
exports.NetworkRequestsTotal = NetworkRequestsTotal;