"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBarCharts = void 0;
var _react = require("react");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBarCharts = ({
  data
}) => {
  const [charts, setCharts] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const chartsN = [];
    if ((data === null || data === void 0 ? void 0 : data.length) > 0) {
      let chartIndex = 0;
      /* We want at most CANVAS_MAX_ITEMS **RESOURCES** per array.
       * Resources !== individual timing items, but are comprised of many individual timing
       * items. The X value of each item can be used as an id for the resource.
       * We must keep track of the number of unique resources added to the each array. */
      const uniqueResources = new Set();
      let lastIndex;
      data.filter(item => true).forEach(item => {
        if (uniqueResources.size === _constants.CANVAS_MAX_ITEMS && item.x > lastIndex) {
          chartIndex++;
          uniqueResources.clear();
        }
        uniqueResources.add(item.x);
        lastIndex = item.x;
        if (!chartsN[chartIndex]) {
          chartsN.push([item]);
          return;
        }
        chartsN[chartIndex].push(item);
      });
    }
    setCharts(chartsN);
  }, [data]);
  return charts;
};
exports.useBarCharts = useBarCharts;