"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviousObjectMetrics = exports.SYNTHETICS_STEP_NAME = exports.SYNTHETICS_STEP_DURATION = exports.SYNTHETICS_ONLOAD_EVENT = exports.SYNTHETICS_LCP = exports.SYNTHETICS_FCP = exports.SYNTHETICS_DCL = exports.SYNTHETICS_CLS = exports.MONITOR_DURATION_US = void 0;
var _reactRouterDom = require("react-router-dom");
var _moment = _interopRequireDefault(require("moment"));
var _use_journey_steps = require("../../monitor_details/hooks/use_journey_steps");
var _use_redux_es_search = require("../../../hooks/use_redux_es_search");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MONITOR_DURATION_US = exports.MONITOR_DURATION_US = 'monitor.duration.us';
const SYNTHETICS_CLS = exports.SYNTHETICS_CLS = 'browser.experience.cls';
const SYNTHETICS_LCP = exports.SYNTHETICS_LCP = 'browser.experience.lcp.us';
const SYNTHETICS_FCP = exports.SYNTHETICS_FCP = 'browser.experience.fcp.us';
const SYNTHETICS_ONLOAD_EVENT = exports.SYNTHETICS_ONLOAD_EVENT = 'browser.experience.load.us';
const SYNTHETICS_DCL = exports.SYNTHETICS_DCL = 'browser.experience.dcl.us';
const SYNTHETICS_STEP_NAME = exports.SYNTHETICS_STEP_NAME = 'synthetics.step.name.keyword';
const SYNTHETICS_STEP_DURATION = exports.SYNTHETICS_STEP_DURATION = 'synthetics.step.duration.us';
const usePreviousObjectMetrics = () => {
  var _data$details, _prevObjectMetrics$ag, _prevObjectMetrics$ag2, _prevObjectMetrics$ag3, _prevObjectMetrics$ag4, _prevObjectMetrics$ag5, _prevObjectMetrics$ag6;
  const {
    monitorId,
    stepIndex,
    checkGroupId
  } = (0, _reactRouterDom.useParams)();
  const {
    data
  } = (0, _use_journey_steps.useJourneySteps)();
  const timestamp = data === null || data === void 0 ? void 0 : (_data$details = data.details) === null || _data$details === void 0 ? void 0 : _data$details.timestamp;
  const {
    data: prevObjectMetrics
  } = (0, _use_redux_es_search.useReduxEsSearch)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    body: {
      track_total_hits: false,
      sort: [{
        '@timestamp': {
          order: 'desc'
        }
      }],
      size: 0,
      runtime_mappings: {
        'synthetics.payload.transfer_size': {
          type: 'long'
        }
      },
      query: {
        bool: {
          filter: [{
            range: {
              '@timestamp': {
                lte: timestamp !== null && timestamp !== void 0 ? timestamp : 'now',
                gte: (0, _moment.default)(timestamp).subtract(1, 'day').toISOString()
              }
            }
          }, {
            term: {
              config_id: monitorId
            }
          }, {
            term: {
              'synthetics.type': 'journey/network_info'
            }
          }, {
            term: {
              'synthetics.step.index': stepIndex
            }
          }, {
            range: {
              '@timestamp': {
                gte: 'now-24h/h',
                lte: 'now'
              }
            }
          }],
          must_not: [{
            term: {
              'monitor.check_group': {
                value: checkGroupId
              }
            }
          }]
        }
      },
      aggs: {
        testRuns: {
          cardinality: {
            field: 'monitor.check_group'
          }
        },
        objectCounts: {
          terms: {
            field: 'http.response.mime_type',
            size: 500
          },
          aggs: {
            weight: {
              sum: {
                field: 'synthetics.payload.transfer_size'
              }
            }
          }
        }
      }
    }
  }, [stepIndex, monitorId, checkGroupId], {
    name: `previousObjectMetrics/${monitorId}/${checkGroupId}/${stepIndex}/`,
    isRequestReady: !!timestamp
  });
  const mimeData = {};
  const testRuns = (_prevObjectMetrics$ag = prevObjectMetrics === null || prevObjectMetrics === void 0 ? void 0 : (_prevObjectMetrics$ag2 = prevObjectMetrics.aggregations) === null || _prevObjectMetrics$ag2 === void 0 ? void 0 : (_prevObjectMetrics$ag3 = _prevObjectMetrics$ag2.testRuns) === null || _prevObjectMetrics$ag3 === void 0 ? void 0 : _prevObjectMetrics$ag3.value) !== null && _prevObjectMetrics$ag !== void 0 ? _prevObjectMetrics$ag : 0;
  prevObjectMetrics === null || prevObjectMetrics === void 0 ? void 0 : (_prevObjectMetrics$ag4 = prevObjectMetrics.aggregations) === null || _prevObjectMetrics$ag4 === void 0 ? void 0 : (_prevObjectMetrics$ag5 = _prevObjectMetrics$ag4.objectCounts) === null || _prevObjectMetrics$ag5 === void 0 ? void 0 : (_prevObjectMetrics$ag6 = _prevObjectMetrics$ag5.buckets) === null || _prevObjectMetrics$ag6 === void 0 ? void 0 : _prevObjectMetrics$ag6.forEach(bucket => {
    mimeData[bucket.key] = {
      weight: bucket.weight.value ? bucket.weight.value / testRuns : 0,
      count: bucket.doc_count / testRuns
    };
  });
  return {
    mimeData
  };
};
exports.usePreviousObjectMetrics = usePreviousObjectMetrics;