"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BrowserMonitorCallout = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _location_form = require("./location_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BrowserMonitorCallout = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _location_form.AGENT_CALLOUT_TITLE,
    size: "s",
    style: {
      textAlign: 'left'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.monitorManagement.agentCallout.content",
    defaultMessage: "To run \"Browser\" monitors on this private location, make sure that you're using the {code} Docker container, which contains the dependencies necessary to run these monitors. For more information, {link}.",
    values: {
      code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "elastic-agent-complete"),
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsLocationFormReadTheDocsLink",
        target: "_blank",
        href: "https://www.elastic.co/guide/en/observability/current/uptime-set-up-choose-agent.html#private-locations",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.monitorManagement.agentCallout.link",
        defaultMessage: "read the docs"
      }))
    }
  })));
};
exports.BrowserMonitorCallout = BrowserMonitorCallout;