"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricItemBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _eui = require("@elastic/eui");
var _monitor_type_badge = require("../../../../common/components/monitor_type_badge");
var labels = _interopRequireWildcard(require("../../../management/monitor_list_table/labels"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricItemBody = ({
  monitor
}) => {
  const tags = monitor.tags;
  const history = (0, _reactRouterDom.useHistory)();
  const typeBadge = /*#__PURE__*/_react.default.createElement(_monitor_type_badge.MonitorTypeBadge, {
    monitorType: monitor.type,
    ariaLabel: labels.getFilterForTypeMessage(monitor.type),
    onClick: () => {
      history.push({
        search: `monitorTypes=${encodeURIComponent(JSON.stringify([monitor.type]))}`
      });
    }
  });
  if (tags.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), typeBadge);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), (tags !== null && tags !== void 0 ? tags : []).length > 0 && /*#__PURE__*/_react.default.createElement(_public.TagsList, {
    prependChildren: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, typeBadge),
    color: "default",
    tags: tags,
    disableExpand: true,
    onClick: tag => {
      history.push({
        search: `tags=${encodeURIComponent(JSON.stringify([tag]))}`
      });
    }
  }));
};
exports.MetricItemBody = MetricItemBody;